package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.io.Serializable;


/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot页面信息定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotPageInfo
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotPageInfo implements Serializable {

    private static final long serialVersionUID = -7771966098426177620L;
    /**
     * 分页属性:是否有下一页
     */
    private boolean hasNext;

    /**
     * 第几页，默认是1
     */
    private Integer pageNo = 1;
    /**
     * 分页属性:每一页的大小，默认是50
     */
    private Integer pageSize = 50;

    /**
     * 分页属性:总共多少页
     */
    private Integer pageCount;
    /**
     * 当前页数量
     */
    private Integer pageCountSize;

    /**
     * 分页属性:总数
     */
    private Integer totalResults;

    /**
     * 分页配置在当前列表组件上
     */
    private boolean pagingConfigOnList;
}
