package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：元数据规则</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotRuleDTO.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 11:04
 */
@Data
public class PcUiBotRuleDTO {

    private List<Map<String, Object>> rules;

    @Data
    public static class Rule {
        /**
         * 作用字段
         */
        private String schema;

        /**
         * 关联字段
         */
        private List<String> linkageSchemas;

        /**
         * 作用路径
         */
        private String path;

        /**
         * 描述
         */
        private String description;

        /**
         * 规则类型，18种
         *
         * @see PcUiBotConstants.RuleKeyType
         */
        private String key;

        /**
         * 触发字段
         */
        private String targetSchema;

        /**
         * 触发条件
         */
        private String condition;

        /**
         * 规则触发机制
         */
        private Trigger trigger;

    }

    @Data
    public static class Trigger {

        /**
         * 触发时机
         */
        private String point;

        /**
         * 触发类型：同步规则(sync)，异步规则(async)
         */
        private String type;

        /**
         * 触发条件
         */
        private String condition;

    }

}
