package com.digiwin.mobile.mobileuibot.proxy.uibot.model;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot运行时-提交action</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotSubmitAction
 * @Author: Zaregoto
 * @Date: 2023/2/27 14:55
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PcUiBotSubmitAction extends PcUiBotAction {

    private static final long serialVersionUID = -3471763189616088249L;
    /**
     * 前端定义的ID
     * confirm:提交 cancel 取消
     */
    private String id;

    /**
     * 前端定义的UI 类型使用到
     */
    private List<Object> backFills;

    private String url;

    /**
     * 默认ACTION
     */
    private boolean defaultAction;

    /**
     * 执行上下文
     */
    private PcUiBotSubmitExecuteContext executeContext;

    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;

    /**
     * 提交的数据源是什么
     * "isBatch": true,
     * "schema": "purchase"
     */
    private PcUiBotSubmitType submitType;

    /**
     * 执行按扭时前端 执行的脚本
     */
    private String actionScript;

    private Object returnText;

    /**
     * 判断是否走流程
     */
    private PcUiBotDataSourceDTO checkCompleteAction;
    /**
     * 在任务结束之后才执行
     */
    private Boolean executeAfterCheckCompleted;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String, String>> addShowFileds;


    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 要执行的附加Action，可以为null
     */
    private List<PcUiBotSubmitAction> attachActions;

    /**
     * 提交数据 特殊处理
     */
    private List<PcUiBotSubmitProcessor> submitProcessors;

    /**
     * 按钮显示顺序，数字越小越显示在页面右侧
     */
    private Integer order;

    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;
    /**
     * 提交后数据的状态
     */
    private String targetDataState;

    /**
     * 确认提示框
     */
    private JSONObject confirm;

    /**
     * 组合Action
     */
    private List<PcUiBotSubmitAction> combineActions;

    /**
     * 配置初始化时，按钮是否可用，
     * ignoreRule：  true 和不配都是不关联
     */
    private Boolean ignoreRule;

//    /**
//     * 附件配置
//     */
//    private AttachApprovalConfigDTO attachmentConfig;

    /**
     * 禁用条件
     */
    private PcUiBotCondition condition;

    /**
     * 隐藏条件
     */
    private PcUiBotCondition hidden;
    /**
     * 隐藏条件
     */
    private Boolean applyAlthoughFinished;

    /**
     * 业务场景相关属性
     */
    private PcUiBotBusinessConfig businessConfig;

    /**
     * 是否存在流程引擎或者任务引擎的action
     *
     * @return
     */
    @JsonIgnore
    public boolean isTaskEngin() {
        if (!CollectionUtils.isEmpty(this.getAttachActions())) {
            for (PcUiBotSubmitAction attachAction : attachActions) {
                if (attachAction.isTaskEngin()) {
                    return true;
                }
            }
        }
        return Objects.equals(PcUiBotConstants.ACTION_CATEGORY_BPM, this.getCategory())
                || Objects.equals(PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE, this.getCategory());
    }


    /**
     * 是否是bpm的 派送关卡
     *
     * @return
     */
    @JsonIgnore
    public boolean isDispatchAction() {
        if (PcUiBotConstants.ACTION_CATEGORY_BPM_TASK_ENGINE.equals(this.getCategory())
                && PcUiBotConstants.ACTION_LIST.contains(this.getServiceId().getName())) {
            //是taskEngine且是dispatch
            return true;
        } else if (PcUiBotConstants.ACTION_CATEGORY_BPM.equals(this.getCategory())) {
            // 是 flowEngine，流程引擎
            return true;
        }
        return false;
    }

    /**
     * 处理扩展参数
     */
    @JsonIgnore
    public void executeExtendParas(Map<String, Object> extendParas, PcUiBotExecuteContext executeContext) {
        if (extendParas == null) {
            extendParas = Maps.newHashMap();
        }
        //双档基础资料编辑页面，才可使用忽略数据变化属性
        boolean isEditPage = Objects.equals(PcUiBotActivityConstants.PATTERN_BASIC_DATA, executeContext.getPattern()) &&
                Objects.equals(UiBotDesignerService.PAGECODE_EDIT_PAGE, executeContext.getPageCode());
        if (!isEditPage && extendParas.containsKey("ignoreDataChange")) {
            extendParas.remove("ignoreDataChange");
        }
        this.setExtendParas(extendParas);
    }
}
