package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot运行时-提交使用的上下文</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotSubmitExecuteContext
 * @Author: Zaregoto
 * @Date: 2023/2/27 14:55
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PcUiBotSubmitExecuteContext implements Serializable {

    private static final long serialVersionUID = -6780674670874383250L;
    /**
     * 语言别
     */
    private String locale;

    /**
     * 客户端来源
     */
    private String clientAgent;

    /**
     * 项目名称
     */
    private String tmProjectId;

    /**
     * 关卡名称
     */
    private String tmActivityId;

    /**
     * 代办项id，一般再提交的时候用
     */
    private Long backlogId;

    /**
     * 提交唯一键
     */
    private Integer submitId;

    /**
     * 流程序号
     */
    private String processSerialNumber;

    /**
     * 流程数据
     */
    private Map<String, Object> bpmData;

    /**
     * 登陆用户
     */
    private PcUiBotAuthoredUser authoredUser;

    /**
     * 代理用户
     */
    private String proxyToken;

    /**
     * 代理租户信息
     */
    private String tenantId;

    /**
     * 页面场景
     * [project-card,project-detail,task-card,task-detail]
     */
    private String pageCode;


    /**
     * 短地址应用的设备类型，目前仅有email
     */
    private String deviceType;

    /**
     * 活动形态分类
     */
    private String pattern;

    /**
     * 活动形态类型
     */
    private String category;


    /**
     * 营运单元
     */
    private Map<String, Object> businessUnit;

    /**
     * 调用链ID
     */
    private String traceId;

    /**
     * 数据来源：PTM表示来源于PTM，其他表示ATMC
     */
    private String dataFrom;


    /**
     * 88:预期任务；89：异动数据异常排除
     */
    private Integer taskType;
    /**
     * 数据一致性异常排除任务卡id
     */
    private Long abnormalWorkitemId;

    /**
     * projectCardId项目卡的Id，用于将来防重复提交
     */
    private Long projectCardId;

    /**
     * 根据标签来执行
     */
    private PcUiBotRelationTag relationTag;

    /**
     * 是否是流程引擎
     */
    private Boolean isTaskEngine;

    /**
     * 移动任务卡/数据录入/发起项目/项目卡数据id
     */
    private String mobileDataId;

    /**
     * 主数据源名称 -- 用于判断是否是主数据源
     */
    private String mainDataSourceName;

    /**
     * 应用ID
     */
    private String application;

    /**
     * 第三方集成 跳转数据驱动任务卡 来源类型
     */
    private String sourceType;

    /**
     * 创建提交上下文环境
     *
     * @param executeContext
     * @return
     */
    public static PcUiBotSubmitExecuteContext create(PcUiBotExecuteContext executeContext, DigiwinAtmcTaskWithBacklogData taskWithBacklogData) {
        PcUiBotSubmitExecuteContext newExecuteContext = PcUiBotSubmitExecuteContext.builder()
                .pageCode(executeContext.getPageCode())
                .pattern(executeContext.getPattern())
                .proxyToken(executeContext.getProxyToken())
                .category(executeContext.getCategory())
                .tmActivityId(executeContext.getTmActivityId())
                .tmProjectId(executeContext.getTmProjectId())
                .locale(executeContext.getLocale())
                .clientAgent(executeContext.getClientAgent())
                .deviceType(executeContext.getDeviceType())
                .authoredUser(executeContext.getAuthoredUser())
                .businessUnit(executeContext.getBusinessUnit())
                .traceId(executeContext.getTraceId())
                .dataFrom(executeContext.getDataFrom())
                .taskType(executeContext.getTaskType())
                .abnormalWorkitemId(executeContext.getAbnormalWorkitemId())
                .submitId(executeContext.getSubmitId())
                .projectCardId(executeContext.getProjectCardId())
                .relationTag(executeContext.getRelationTag())
                .isTaskEngine(executeContext.getIsTaskEngine())
                .mobileDataId(executeContext.getMobileDataId())
                .mainDataSourceName(executeContext.getMainDataSourceName())
                .application(executeContext.getApplication())
                .sourceType(executeContext.getSourceType())
                .build();
        if (taskWithBacklogData != null) {
            newExecuteContext.setBusinessUnit(taskWithBacklogData.getBusinessUnit());
            newExecuteContext.setBacklogId(taskWithBacklogData.getBacklog().get(0).getBacklogId());
            newExecuteContext.setBpmData(taskWithBacklogData.getBpmData());
            newExecuteContext.setProcessSerialNumber(taskWithBacklogData.getProcessSerialNumber());
        }

        return newExecuteContext;
    }
}