package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：标签请求入参</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTagRequest.java
 * @Author: wangjwc
 * @Date: created at 2023/11/14 18:12
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PcUiBotTagRequest implements Serializable {

    private static final long serialVersionUID = 5258504106579370076L;

    /**
     * 关联；包含：用户身份和任务id（可能包含queryTagSuffix）；例如：["performer","PurchaseChangeInitiate"]
     */
    private List<String> relationIds;

    /**
     * 数据源id，actionId
     */
    private String resourceId;

    /**
     * 任务编码，任务id
     */
    private String activityCode;

}
