package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBpmActivityStepDTO;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBpmActivityWorkitem;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：任务相关的数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TaskData.java
 * @Author: wangjwc
 * @Date: created at 2023/7/13 20:16
 */
@Data
public class PcUiBotTaskData {

    /**
     * ActivityDescription - 任务开始时间
     */
    private String taskStartTime;

    /**
     * ActivityDescription - 预计开工日期
     */
    private String taskDueDate;

    /**
     * ActivityDescription - 预计开工日期名称
     */
    private String taskDueDateName;

    /**
     * ActivityDescription - 来源任务ID
     */
    private List<Object> taskSourceIds;


    /**
     * ActivityDescription - 来源任务名称
     */
    private String taskSourceName;

    /**
     * ActivityTitle - 截止时间
     */
    private String endTime;


    /**
     * ActivityTitle - 名称
     */
    private String name;


    /**
     * ActivityTitle - 倒计时
     */
    private String remainTime;

    /**
     * ActivityTitle -签核状态
     */
    private String approvalState;


    /**
     * 待办项Id
     */
    private Long id;

    private Boolean isEmergency;

    /**
     * 标题
     */
    private String title;

    /**
     * 描述
     */
    private String description;

    /**
     *
     */
    private String subDescription;


    /**
     * 任务子名称，对应任务定义中的startApproveActivityName
     */
    private String subName;


    private String taskEndTime;

    private String taskName;

    private List<DigiwinAtmcBpmActivityStepDTO> steps;


    private String taskSupplier;


    /**
     * 活动的转派信信息
     */
    private Map<String, Object> reassign;

    /**
     * 已读次数
     */
    private Integer readCount;


    /**
     * 逾期信息
     */
    private String overdueDate;

    /**
     * 审核意见
     */
    private String approvalMessage;


    private String bpmSignReason;


    /**
     * 给前端使用的扩展字段
     */
    private Map<String, Object> extendedFields;

    /**
     * 方案
     */
    private String programme;

    /**
     * 发起人
     */
    private String initiator;

    /**
     * 流程序号
     */
    private String processSerialNumber;

    /**
     * 关卡id
     */
    private String workitemId;

    /**
     * 流程发起时间 yyyy-MM-dd HH:mm:ss
     */
    private String processCreateTime;

    private List<String> eocName;

    private DigiwinAtmcBpmActivityWorkitem approvalInfo;

    /**
     * 任务是否合并
     */
    private Boolean merge;
    /**
     * 最小预计完成时间 yyyy-MM-dd HH:mm:ss
     */
    private String planEndTimeMin;
    /**
     * 最大预计完成时间 yyyy-MM-dd HH:mm:ss
     */
    private String planEndTimeMax;

    /**
     * 返回母任务数据
     */
    private Object deriveMainTask;
}
