package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：任务页面的的定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTaskPageDefine.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 19:18
 */
@Data
public class PcUiBotTaskPageDefine extends PcUiBotPageDefine {
    private static final long serialVersionUID = 5825383835380004115L;
    /**
     * 版本号
     */
    private String version;
    /**
     * 上一个的执行者的字段
     */
    private List<String> prePerformer;

    private PcUiBotExecuteContext executeContext;

    /**
     * 执行的目标字段
     */
    private List<String> subjectMatterTargets;
    /**
     * 执行标的物字段
     */
    private List<String> subjectMatter;
    /**
     * 执行标的物字段属性
     */
    private List<String> subjectMatterProperties;

    /**
     * 当前角色关注的字段
     */
    private List<String> roleAttention;

    /**
     * 业务主键的关联属性
     */
    private List<String> dataKeyProperties;

    /**
     * 执行期望
     */
    private List<String> subjectExpect;

    /**
     * 执行落差量化结果
     */
    private List<String> subjectShortfall;


    /**
     * 显示的按钮的标题
     */
    private String queryTitle;
    /**
     * 数据行数
     */
    private Integer rowSize;
    /**
     * 显示获总条数类型
     */
    private String rowSizeType;
    /**
     * 模板那边使用到
     */
    private String type;

    /**
     * 签核任务的发起任务名称
     */
    private String startApproveActivityName;

    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 任务是否已经完成
     */
    private Boolean finished;

    /**
     * 任务提交时的id
     */
    private String finishedActionId;
    /**
     * 任务完成是的标题
     */
    private String finishedTitle;

    /**
     * 任务上配置 domain，主要用于所属领域
     */
    private List<String> domain;

    /**
     * 默认选中数据状态
     */
    private Boolean isDefault;

    /**
     * 任务是否合并
     */
    private Boolean merge;
}
