package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的行动实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmAction
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotTmAction extends PcUiBotTmActionBase {

    private static final long serialVersionUID = 7845035647109921175L;

    /**
     * 前端定义的UI 类型使用到
     */
    private List<Object> backFills;

    /**
     * 是否通知BPM，只有submitAction才会用到此值
     */
    @Deprecated
    private Boolean dispatchBPM;

    /**
     * 是否通知引擎，任务已经处理完成，只有submitAction才会用到此值
     */
    private boolean dispatch;

    /**
     * 停止bpm流程
     */
    private boolean terminateProcess;

    /**
     * 附加ACTION  当本ACITON 执行完成后去执行另个的API
     */
    private List<PcUiBotTmAction> attachActions;

    /**
     * 提交API 缺失显示字段
     */
    private List<Map<String, String>> addShowFileds;

    /**
     * 检查完成的action,只有submitAction才会用到此值
     */
    private PcUiBotTmQueryAction checkCompleteAction;

    /**
     * 在任务结束之后才执行
     */
    private Boolean executeAfterCheckCompleted;

    /**
     * submitAction显示的标题
     * 例如：已提交，已审核等
     * 如：{\"zh_TW\":\"已通知運維\",\"en_US\":\"Has notified maintainer\",\"zh_CN\":\"已通知运维\"}
     */
    private String returnText;

    /**
     * 提交的数据源是什么
     * "isBatch": true,
     * "schema": "purchase"
     */
    private PcUiBotSubmitType submitType;

    /**
     * 执行按扭时前端 执行的脚本 --- 迭代8 迁移到DataProcess 处理
     */
    private String actionScript;

    /**
     * 是否是默认提交按钮
     */
    private boolean defaultAction;

//    /**
//     * 是否全部提交（check 数据过滤）
//     */
//    private Boolean submitAll;

    /**
     * 提交后数据的状态
     */
    private String targetDataState;

    /**
     * 确认提示框
     */
    private JSONObject confirm;

    /**
     * 组合Action
     */
    private List<PcUiBotTmAction> combineActions;

    /**
     * 配置初始化时，按钮是否可用，
     * ignoreRule：  true 和不配都是不关联
     */
    private Boolean ignoreRule;

    /**
     * 用于用户行为轨迹上报的，轨迹代号
     */
    private String trackCode;

    /**
     * 可用条件
     * 应用配置表达式：
     * false禁用
     * true 启用（默认不配置为启用）
     */
    private String condition;

    /**
     * 触发时机，与condition一起使用才有效
     * init ：初始化，默认或不配置时为init
     * dataChanged：数据变化时
     */
    private List<String> trigger;

    /**
     * 隐藏条件
     */
    private PcUiBotTmCondition hidden;
    /**
     * 任务已关闭，是否还需要apply该action
     */
    private Boolean applyAlthoughFinished;

    public void setTrackCode(String trackCode) {
        this.trackCode = trackCode;
    }

    public String getTrackCode() {
        return StringUtils.hasLength(this.trackCode) ? this.trackCode : PcUiBotConstants.DEFAULT_BUTTON_TRACK_CODE;
    }
}
