package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的行动基类实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmActionBase
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotTmActionBase implements Serializable {

    private static final long serialVersionUID = -7868758050154796374L;

    /**
     * 移动设计器submitAction唯一标识，关联使用 -- 移动设计器新增属性
     */
    private String uuid;
    /**
     * 移动设计器submitAction的btnId，相当于schema，提供给前端，作用于规则校验 -- 移动设计器新增属性
     */
    private String btnId;
    /**
     * 移动设计器动作类型,跳转页面/提交 -- 移动设计器新增属性
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum
     */
    private String btnType;
    /**
     * 移动设计器跳转类型，相关配置属性 -- 移动设计器新增属性
     */
    private UiBotJumpAction jumpAction;

    /**
     * 序号
     */
    private int sequence;

    /**
     * id,唯一值
     */
    private String id;


    /**
     * 名称
     */
    private String name;

    /**
     * 数据源返回的结果集中数据主键
     */
    private List<String> dataKeys;

    /**
     * 显示名称
     */
    private String title;

    /**
     * 服务类型
     * 1.ESP
     */
    private String type;


    /**
     * 数据源ID
     */
    private String actionId;

    /**
     * 按钮类型标示
     */
    private String actionType;

    /**
     * 服务名称
     */
    private String serviceName;

    /**
     * 服务执行URL
     */
    private String url;

    /**
     * 是否代理
     */
    private Boolean needProxyToken;

    /**
     * ESP 使用的产品名称
     */
    private String productName;

    /**
     * API 入参 参数转换设定
     */
    private List<PcUiBotActionParameterMapping> actionParams;

    /**
     * API 透传的CONSTANT类型入参，不需要转换
     */
    private Map<String, Object> paras;

    /**
     * 扩展参数，在需要做额外处理时可以使用
     */
    private Map<String, Object> extendParas;

    /**
     * 开窗or提交时追加营运单元信息
     */
    private List<Map> appendRowBusinessUnitSelect;

    /**
     * 是否是客制 ture：是客制；false：非客制（默认不填为非客制）
     */
    private Boolean isCustomize;

    private String schema;

    /**
     * 配置数据源查询入参
     */
    private List<PcUiBotActionSearchInfoMapping> searchInfos;
}
