package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的查询活动定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmActivity.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 10:42
 */
@Data
public class PcUiBotTmActivity {

//    /**
//     * 版本号
//     */
//    private String version;
    /**
     * 应用
     */
    private String application;
    /**
     * 大分类
     */
    private String pattern;

    /**
     * 小分类
     */
    private String category;

    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 活动名称
     * 是多语言的json格式
     */
    private Object activityName;


    /**
     * 数据源定义
     */
    private Map<String, PcUiBotTmQueryAction> dataSources;

    /**
     * 数据API 数据查询条件过滤器
     * P4S1以后的配置不在使用此属性----即将废弃!!
     */
    private List<PcUiBotTmDataFilter> dataFilters;

    /**
     * 数据处理器定义，迭代17之后放到了数据源里面去了
     */
    @Deprecated
    private List<PcUiBotTmDataProcess> dataProcessors;

    /**
     * 每个页面固定的属性设置
     */
    private PcUiBotTmPage pages;

//    /**
//     * 自定义租户的任务标题定义
//     */
//    private TenantCardTitleDefinition tenantCardTitleDefinition;

    /**
     * 活动定义的全局参数
     * 目前用到的币别
     */
    private Map<String, Object> activityParameter;

    /**
     * 签核任务的发起任务名称
     */
    private String startApproveActivityName;

    /**
     * 签核-可退回的任务ID列表
     */
    private List<String> startApproveActivity;

    /**
     * 新的签核定义
     */
    private PcUiBotTmApprove approve;

    /**
     * 签核定义,迭代16采用新的配置approve
     */
    @Deprecated
    private List<PcUiBotTmApproval> approves;


    /**
     * 签核-0串接 1并接，目前场景只有串接
     */
    private Integer groupDispatchType;

    /**
     * 附件信息
     */
    private PcUiBotAttachmentConfigInfo attachment;

    /**
     * 任务逾期处理规则
     */
    private List<PcUiBotTmOverdueRule> overdueRules;

    /**
     * 权限配置
     */
    private String authorityPrefix;

    /**
     * 用于区分是流程引擎还是任务引擎，
     * 业务逻辑同之前的version
     */
    private String datamap;

    /**
     * 任务是否合并
     */
    private Boolean merge;

    /**
     * 判断任务类型,auto代表自动任务类型
     */
    private String executeType;

    /**
     * 用于存放客制规则
     */
    private Map<String, Object> mechnismConfig;

    /**
     * 多语言
     */
    private Map<String, Map<String, String>> lang;

    /**
     * 绑定表单信息
     */
    private PcUiBotTmFormInfo bindForm;

    /**
     * 字段权限的配置
     */
    private List<Map<String, List<PcUiBotModelField>>> fieldConfig;

    @JsonIgnore
    public Boolean isTaskEngine() {
        return this.getDatamap() != null && "2.0".equals(this.getDatamap());
    }

    @JsonIgnore
    public Boolean isFlowEngine() {
        return this.getDatamap() == null || "1.0".equals(this.getDatamap());
    }

    public String getActivityNameByLocale() {
        Object value = this.activityName;
        String locale = AppRequestContext.getContextEntity().getLocale();
        if (value instanceof Map) {
            Map<String, String> languageMap = (Map<String, String>) value;
            return languageMap.get(locale);
        }
        String strValue = (String) value;
        if (CollectionUtils.isEmpty(this.lang)) {
            return strValue;
        }
        Map<String, String> activityNameMap = this.lang.get("activityName");
        if (CollectionUtils.isEmpty(activityNameMap)) {
            return strValue;
        }
        return activityNameMap.get(locale);
    }

    /**
     * 根据locale获取正确的文字
     *
     * @param value
     * @return
     */
    public String getValueByLocale(Object value) {
        if (value instanceof Map) {
            Map<String, String> languageMap = (Map<String, String>) value;
            return languageMap.get(AppRequestContext.getContextEntity().getLocale());
        }
        return (String) value;
    }

    /**
     * 是否设计过移动DSL，主要用来判断走什么页面构建策略
     */
    public boolean getIsDesignerDsl() {
        List<PcUiBotTmDataState> dataStates = Optional.ofNullable(this.pages).map(PcUiBotTmPage::getDataStates).orElse(null);
        if (CollectionUtils.isEmpty(dataStates)) {
            return false;
        }
        for (PcUiBotTmDataState dataState : dataStates) {
            if (!CollectionUtils.isEmpty(dataState.getLayout())) {
                // 表示存在移动设计DSL节点 layout
                return true;
            }
        }
        return false;
    }

    /**
     * 是否存在流程设定的表单信息下的基础数据录入的code
     */
    public boolean isbindFormCode() {
        if (this.bindForm == null) {
            return false;
        }
        return this.bindForm.getFormCode() != null;
    }
}
