package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的 对API的参数过滤</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmDataFilter.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 10:45
 */
@Data
public class PcUiBotTmDataFilter {


    /**
     * Filter 编码
     */
    private String code;
    /**
     * 默认优先使用
     */
    private Boolean defaultFilter;


    /**
     * 显示名称
     */
    private String title;

    /**
     * 查询任务的类型
     */
    private String queryTaskType;

    /**
     * 过滤器类型
     */
    private String type;


    /**
     * 为true时，表示使用API进行过滤，服务端过滤，使用conditions，
     * 为false时，表示客户端过滤，使用scriptCondition
     */
    private boolean apiFilter;

    /**
     * 过滤器描述（需要外显）
     */
    private String description;

    private PcUiBotTmScriptCondition scriptCondition;

    /**
     * 作用范围（项目,任务 --卡片，详情）
     */
    private String applyTo;

    /**
     * 作用于数据源
     */
    private List<String> dataSourceNames;


    private List<PcUiBotTmFilterCondition> apiCondition;

    /**
     * 显示前limit条数据
     */
    private Integer limit;

    /**
     * 显示获总条数类型
     */
    private String rowSizeType;

    /**
     * 是否显示数据状态的标题 -- 移动设计器新增属性
     * 默认true显示
     */
    private Boolean showTitle = true;
}
