package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTaskWithBacklogData;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的数据处理器实体</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmDataProcess
 * @Author: zaregoto
 * @Date: 2023/2/27 16:30
 */
@Data
public class PcUiBotTmDataProcess implements Serializable {

    private static final long serialVersionUID = 8405865531851244912L;
    /**
     * 处理器类型
     */
    private String type;

    /**
     * 处理器服务名称
     */
    private String serviceName;

    /**
     * 执行时机点，为空表示每个action执行完毕后
     * executeCompleted-表示所有action执行完毕后
     */
    private String activePoint;

    /**
     * 作用范围（项目,任务 --卡片，详情）
     */
    private String applyTo;

    /**
     * 作用于dataFilter,优先于 dataSourceNames
     */
    private List<String> dataFilterNames;

    /**
     * 作用于数据源
     */
    private List<String> dataSourceNames;

    /**
     * 用于返回的数据和任务的参数之间的映射，在批量查询数据时，可以让返回的数据附加对应的任务
     */
    private PcUiBotBusinessKeyMappingDTO mappingKeys;

    /**
     * 参数
     */
    private Object paras;

    /**
     * 每个查询对应的任务数据
     */
    private DigiwinAtmcTaskWithBacklogData taskWithBacklogData;

    /**
     * 批量查询时，则是所有的任务
     */
    private List<DigiwinAtmcTaskWithBacklogData> taskWithBacklogDataList;

    /**
     * 每个查询对应的项目数据
     */
    private DigiwinAtmcProjectData projectData;

    public PcUiBotTmDataProcess clone() {
        PcUiBotTmDataProcess tmDataProcess = new PcUiBotTmDataProcess();
        tmDataProcess.setParas(this.paras);
        tmDataProcess.setActivePoint(activePoint);
        tmDataProcess.setApplyTo(applyTo);
        tmDataProcess.setDataFilterNames(dataFilterNames);
        tmDataProcess.setDataSourceNames(dataSourceNames);
        tmDataProcess.setServiceName(serviceName);
        tmDataProcess.setType(type);
        tmDataProcess.setMappingKeys(this.mappingKeys);
        return tmDataProcess;
    }

}
