package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.designer.uibot.page.PageFieldMetaData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的查询 Page中的dataState</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmDataState.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 11:53
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PcUiBotTmDataState {

    /**
     * 主键，必须有
     */
    private String code;

//    /**
//     * 数据状态
//     */
//    private List<String> dataState;

    /**
     * dataFilter的code，表示使用的dataFilter
     * P4S1以后的配置不在使用此属性----即将废弃!!
     */
    private String dataFilterCode;

    /**
     * P4S1配置设计器将dataFilter从TmActivity移到TmDataState
     */
    private PcUiBotTmDataFilter dataFilter;


    /**
     * 开窗等操作
     */
    private List<PcUiBotTmOperation> operations;

    /**
     * 提交ACTION
     */
    private List<PcUiBotTmAction> submitActions;

    /**
     * 扩展字段，临时存放
     * 目前在模板中使用，以后需要重新定义结构
     */
    private Map<String, Object> extendedFields;

    /**
     * 提交的逻辑家，是否多选，以及提交的数据源
     */
    private PcUiBotSubmitType submitType;


    /**
     * 勾选是否合并选择
     * 老表格的合并单元格的功能。。。。。。待废弃
     * 就是有合併單元格的時候
     * 勾選欄要不要合併
     */
    private Boolean multipleSelectMerge;

//    /**
//     * 自定义标签
//     */
//    private List<TmSummaryField> summaryFields;

    /**
     * 自定义卡片状态
     */
    private List<PcUiBotTmActivityStates> taskStates;

    /**
     * table 分组设置
     */
    private JSONObject settings;

    /**
     * 撤回的action定义
     */
    private PcUiBotTmAction abortTaskAction;

    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;

    /**
     * 是否合并查询所有的任务数据,主要是项目卡里需要显示n个任务的数据，合并查询提高效率
     */
    private Boolean mergeQuery;

    /**
     * 启用分页
     */
    private Boolean enablePaging;

//    /**
//     * 栅格
//     */
//    private TmGridConfig gridConfig;

    /**
     * 配置设计器上保存的词库内容
     */
    private PageFieldMetaData showMetadatas;

    /**
     * true:使用虚拟滚动，false/不存在使用默认分页方式
     */
    private Boolean enableVirtualScrolling;
    /**
     * true：所有数据全选 false或者不存在，则使用当前页全选
     */
    private Boolean enableSelectAll;


//    /**
//     * 分页相关的配置信息
//     */
//    private TmFilterConfig filterConfig;

    /**
     * 分页是否启用后端分页true：使用后端  false或者为null。使用前端分页
     */
    private Boolean enableBackEndPaging;

    /**
     * 分页是否启用后端分页true限制，开启限制后，将只有web端支持后端分页
     */
    private Boolean enableBackEndPagingLimit;

//    /**
//     * 表格设定项
//     */
//    private List<GridSetting> gridSettings;

    /**
     * 是否自动追加"已搁置"页签
     * true：追加
     * false：不追加
     * 默认true
     */
    private Boolean autoAppendShelvedDataState = Boolean.TRUE;

    /**
     * 单身页签
     */
    private List<PcUiBotTmTab> tabs;

    /**
     * 判断是否开启服务端筛选
     */
    private Boolean enableFilter;

//    /**
//     * 页面控件和布局，用于存放低代码设计界面的DSL布局和组件
//     */
//    private List<Object> layout;

    private List<PcUiBotTmDataViewQuery> dataViewQuerys;

    /**
     * 页面hooks，用于切面
     */
    private List<Map<String, Object>> hooks;


    // ------------------------移动设计器新增属性--------------------------------
    /**
     * 预设页面，进入页面默认显示的数据状态code -- 移动设计器新增字段
     */
    private String defaultTabMobileCode;

    /**
     * 是否显示单头
     */
    private Boolean showSingleHeadFrom;
    /**
     * 移动--用于存放低代码设计界面的DSL布局和组件
     */
    private List<Layout> layout;
    /**
     * 移动页面控件和布局
     */
    private List<UiBotPageLayout> pageLayout;
    /**
     * 移动任务提示配置
     */
    private UiBotTipSetting tipSetting;

    /**
     * 是否使用dataSourceName做为M
     * 默认null是false的逻辑
     * true：使用dataSourceName做为M
     * false：不使用dataSourceName做为M，保持之前逻辑不动
     */
    private Boolean masterFromDataSourceName ;

    public List<UiBotPageLayout> getPageLayout() {
        if (null == pageLayout && !CollectionUtils.isEmpty(layout)) {
            // 设计器，现阶段只有一个元素，表示移动页面配置
            pageLayout = Optional.ofNullable(this.layout.get(0))
                    .map(Layout::getData)
                    .map(r -> {
                        MobileRenderDataUtil.multilingualProcessing(r, AppRequestContext.getContextEntity().getLocale());
                        return r;
                    })
                    .map(map -> map.get("data"))
                    .map(r -> JsonUtil.objectToJavaObject(r,
                            new TypeReference<List<UiBotPageLayout>>() {
                            })
                    )
                    .orElse(null);
            if (!CollectionUtils.isEmpty(this.pageLayout)) {
                this.pageLayout.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));
            }
        }
        return pageLayout;
    }

    public UiBotTipSetting getTipSetting() {
        if (null == tipSetting && !CollectionUtils.isEmpty(layout)) {
            // 设计器，现阶段只有一个元素，表示移动页面配置
            tipSetting = Optional.ofNullable(this.layout.get(0))
                    .map(Layout::getData)
                    .map(map -> map.get("tipSetting"))
                    .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<UiBotTipSetting>() {
                    }))
                    .orElse(null);
        }
        return tipSetting;
    }

    @Data
    public static class Layout {
        String schema;
        String componentType;
        Map<String, Object> data;
    }

    public Boolean getShowTitle() {
        return Optional.ofNullable(this.dataFilter)
                .map(PcUiBotTmDataFilter::getShowTitle)
                .orElse(null);
    }
}
