package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数据视图查询</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmDataViewQuery.java
 * @Author: wangjwc
 * @Date: created at 2023/12/26 10:30
 */
@Data
public class PcUiBotTmDataViewQuery implements Serializable {
    private static final long serialVersionUID = -4360348798866818801L;

    /**
     * 视图编码
     */
    private String code;

    /**
     * 视图名称
     */
    private String name;

    /**
     * 视图类型
     */
    private String viewType;

    /**
     * 视图序号；默认为0
     */
    private long sort;

    /**
     * 是否默认视图
     */
    private Boolean isDefault;

    /**
     * 产品编码
     */
    private String productCode;

    /**
     * 排序
     */
    private List<Map<String, Object>> orderList;

    /**
     * 过滤
     */
    private List<Map<String, Object>> queryConditions;

    /**
     * 回参
     */
    private Map<String, Object> returnFields;

    /**
     * 表格
     */
    private List<Map<String, Object>> tables;

    /**
     * 视图显示字段
     */
    private PcUiBotTmViewShowFields viewShowFields;
    /**
     * 视图显示字段 -- 移动配置
     */
    private PcUiBotTmViewShowFieldsMobile viewShowFieldsMobile;

}
