package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.operation.PcUiBotTmOperation;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的查询 页面定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmPage.java
 * @Author: wangjwc
 * @Date: created at 2023/7/12 11:41
 */
@Data
public class PcUiBotTmPage {

    /**
     * 参考交期回复型和机制型
     */
    private String title;
    /**
     * 参考交期回复型和机制型
     */
    private String subTitle;
    /**
     * 参考交期回复型和机制型
     */
    private String description;
    /**
     * 参考交期回复型和机制型
     */
    private String subDescription;

    /**
     * 上一个的执行者的字段
     */
    private List<String> prePerformer;

    /**
     * 执行的目标字段
     */
    private List<String> subjectMatterTargets;
    /**
     * 执行标的物字段
     */
    private List<String> subjectMatter;
    /**
     * 执行标的物字段
     */
    private List<String> subjectMatterProperties;

    /**
     * 当前角色关注的字段
     */
    private List<String> roleAttention;


    /**
     * 业务主键的关联属性
     */
    private List<String> dataKeyProperties;

    /**
     * 执行期望
     */
    private List<String> subjectExpect;

    /**
     * 执行落差量化结果
     */
    private List<String> subjectShortfall;

    /**
     * 显示browse-page字段
     */
    private List<String> showDataProperties;

    /**
     * 开窗等操作
     */
    private List<PcUiBotTmOperation> operations;

    /**
     * 提交ACTION
     */
    private List<PcUiBotTmAction> submitActions;

    /**
     * 是否显示submitActions，默认为true，如果null也是显示true
     * 目前只有客制会用到
     */
    private Boolean showSubmitActions;

    /**
     * 扩展字段，临时存放
     * 目前在模板中使用，以后需要重新定义结构
     */
    private Map<String, Object> extendedFields;


    /**
     * 是否合并查询所有的任务数据,主要是项目卡里需要显示n个任务的数据，合并查询提高效率
     */
    private Boolean mergeQuery;

    /**
     * 勾选框是否合并选择
     */
    private Boolean multipleSelectMerge;

    /**
     * 提交的逻辑家，是否多选，以及提交的数据源
     */
    private PcUiBotSubmitType submitType;

//    /**
//     * 自定义标签
//     */
//    private List<TmSummaryField> summaryFields;

    /**
     * 自定义卡片状态
     */
    private List<PcUiBotTmActivityStates> taskStates;

    /**
     * table 分组设置
     */
    private JSONObject settings;

    /**
     * 撤回的action定义
     */
    PcUiBotTmAction abortTaskAction;


    /**
     * 启用状态管理
     */
    private Boolean enableDataState = Boolean.FALSE;

    /**
     * 启用精简报文，默认不开启
     */
    private Boolean enableSimplifyPack = Boolean.FALSE;

    /**
     * 数据状态列表，有几个状态，就显示几个页签
     */
    private List<PcUiBotTmDataState> dataStates;

    /**
     * 自定义组件类型
     */
    private Boolean isCustomize;

    /**
     * 如果是客制，可以要求返回原始的布局到客制组件里，供前端使用
     */
    private Boolean needOriginalLayout;

    /**
     * 使用的数据源，这个定义，以此为准
     */
    private String dataSourceName;


    /**
     * 状态标记statusFlag(true、false)，默认没有配置时为false;
     * a、当配置这个状态标记(true)的时候，将变化的数据返回给API，并且打上标记（add、edit、del）——只传变化的数据给API；
     * b、当没有配置这个状态标记(false)时；将界面上全部数据传给API。——将界面上看到的全部数据传给API
     */
    private Boolean statusFlag;

    /**
     * 任务上配置 domain，主要用于所属领域
     */
    private List<String> domain;

//    /**
//     * 任务上配置客制tag字段
//     */
//    private List<TmCustomizeTags> customizeTags;

//    /**
//     * 树
//     */
//    private TmTreeConfig treeConfig;

    /**
     * 启用分页
     */
    private Boolean enablePaging;

    /**
     * 分页是否启用后端分页true：使用后端  false或者为null。使用前端分页
     */
    private Boolean enableBackEndPaging;

    /**
     * 分页是否启用后端分页true限制，开启限制后，将只有web端支持后端分页
     */
    private Boolean enableBackEndPagingLimit;

//    /**
//     * 栅格
//     */
//    private TmGridConfig gridConfig;

//    /**
//     * 词库，如：控制表格列的显示与隐藏
//     */
//    private List<TmWordCapability> wordCapability;

//    /**
//     * 函数参数和报表参数的依赖关系
//     */
//    private List<ReferenceReportParameter> referenceReportParameters;

    /**
     * 是否自动追加数据终止页签
     * true：追加
     * false：不追加
     * 默认true
     */
    private Boolean autoAppendTerminateDataState = Boolean.TRUE;

    /**
     * 是否自动追加"已搁置"页签
     * true：追加
     * false：不追加
     * 默认true
     */
    private Boolean autoAppendShelvedDataState = Boolean.TRUE;

    /**
     * 移动--页面控件和布局，用于存放低代码设计界面的DSL布局和组件
     * wjw TODO: 2023/11/21
     * 任务卡流程：TmActivity.tmPage.tmDataState(layout) → TmActivity.tmPage.tmDataState(pageLayout) → pageDefine(pageLayout) → UiBotLayout.UiBotQueryButton(pageLayout)使用此DSL
     * 基础数据录入流程：TmActivity.tmPage(layout) → TmActivity.tmPage.tmDataState(layout) → TmActivity.tmPage.tmDataState(pageLayout) → pageDefine(pageLayout)使用此DSL
     */
    private List<PcUiBotTmDataState.Layout> layout;

    /**
     * 页面规则，用于存放低代码设计界面的DSL规则
     */
    private List<Map<String, Object>> rules = new ArrayList<>();

    /**
     * 页面hooks，用于切面
     */
    private List<Map<String, Object>> hooks;

//    /**
//     * 表格设定项
//     */
//    private List<GridSetting> gridSettings;

    /**
     * 基础资料作业的说明
     */
    private String explanation;

    /**
     * 单身页签
     */
    private List<PcUiBotTmTab> tabs;

    private List<PcUiBotTmDataViewQuery> dataViewQuerys;

    /**
     * 关联数据源名称
     */
    private List<String> dataSourceNames;


    //---------------------------移动设计器新增属性--------------------------------
    /**
     * 预设页面，进入页面默认显示的数据状态code -- 移动设计器新增字段
     */
    private String defaultTabMobileCode;

    /**
     * 是否显示单头
     */
    private Boolean showSingleHeadFrom;

    /**
     * 是否使用dataSourceName做为M
     * 默认null是false的逻辑
     * true：使用dataSourceName做为M
     * false：不使用dataSourceName做为M，保持之前逻辑不动
     */
    private Boolean masterFromDataSourceName;
}

