package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：鼎捷雅典娜知识图谱定义的查询行动定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmQueryAction
 * @author xujinc
 * @date 2024/10/14 10:07
 */
@Data
public class PcUiBotTmQueryAction extends PcUiBotTmActionBase {
    private static final long serialVersionUID = -7777267947406326285L;
    
    /**
     * 查询的笔数
     */
    private Integer limit;

    /**
     * 是否为集合数据
     */
    private Boolean notArray;

    /**
     * 数据处理器定义
     */
    private List<PcUiBotTmDataProcess> dataProcessors;


    private Boolean override = false;

    /**
     * 如果是merge类型的数据源,需要定义左边的数据源
     */
    private PcUiBotTmQueryAction left;

    /**
     * 如果是merge类型的数据源,需要定义主待合并的数据源
     */
    private List<PcUiBotTmQueryAction> rightList;

    /**
     * 提供的数据源描述，如果数据源非esp的，或者通过actionid获取不到元数据的，可以通过这个集合来定义数据源的结果
     */
    private List<PcUiBotMetadataField> metadataFields;

    /**
     * 视图编码；若存在，则表示为视图开窗；
     */
    private String viewCode;

    /**
     * 数据视图查询
     */
    private PcUiBotTmDataViewQuery dataViewQuery;
}
