package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数据视图布局 -- PC结构</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmViewShowFields.java
 * @Author: wangjwc
 * @Date: created at 2023/12/26 10:28
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PcUiBotTmViewShowFields extends PcUiBotTmViewShowFieldsBase {
    private static final long serialVersionUID = -4433632875925163626L;

    // 需注意：pc此字段的配置属性 和 移动此字段的配置属性不一样
    @JsonProperty("field_dsl")
    private Map<String, Object> fieldDsl;

    private List<PcUiBotTmViewShowFields> field;

    public List<PcUiBotTmViewShowFields> getField() {
        if (this.field == null) {
            return this.field = new ArrayList<>();
        }
        this.field.forEach(f -> f.setPath(this.getFullName()));
        return this.field;
    }
}
