package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * <p>功能描述：数据视图布局 -- 基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmViewShowFieldsBase.java
 * @Author: wangjwc
 * @Date: created at 2024/2/23 14:23
 */
@Data
public class PcUiBotTmViewShowFieldsBase implements Serializable {
    private static final long serialVersionUID = -454787759460980934L;

    @JsonProperty("is_datakey")
    private String isDataKey;

    @JsonProperty("can_sort")
    private Boolean canSort;

    @JsonProperty("can_filter")
    private Boolean canFilter;

    @JsonProperty("data_name")
    private String dataName;

    @JsonProperty("data_type")
    private String dataType;

    private String description;

    @JsonProperty("is_array")
    private Boolean isArray;

    @JsonProperty("enum_key")
    private String enumKey;
    /**
     * 所在路径
     */
    private String path;

    public Boolean isArray() {
        return BooleanUtils.isTrue(this.getIsArray());
    }

    /**
     * 是不是简单的字段，非集合，非对象
     *
     * @return
     */
    @JsonIgnore
    public boolean isSimpleField() {
        if (PcUiBotConstants.DataType.OBJECT.equals(this.getDataType())) {
            return false;
        }
        return !BooleanUtils.isTrue(this.getIsArray());
    }

    @JsonIgnore
    public String getFullName() {
        if (StringUtils.hasText(this.getPath())) {
            return this.getPath() + "." + this.getDataName();
        } else {
            return this.getDataName();
        }
    }
}
