package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.BooleanUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：数据视图布局 -- mobile结构</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PcUiBotTmViewShowFieldsMobile.java
 * @Author: wangjwc
 * @Date: created at 2024/2/23 14:23
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PcUiBotTmViewShowFieldsMobile extends PcUiBotTmViewShowFieldsBase {
    private static final long serialVersionUID = -4476720652009612788L;

    // 需注意：pc此字段的配置属性 和 移动此字段的配置属性不一样
    @JsonProperty("field_dsl")
    private Map<String, Object> fieldDsl;

    private List<PcUiBotTmViewShowFieldsMobile> field;

    public List<PcUiBotTmViewShowFieldsMobile> getField() {
        if (this.field == null) {
            return this.field = new ArrayList<>();
        }
        this.field.forEach(f -> f.setPath(this.getFullName()));
        return this.field;
    }

    @JsonIgnore
    public FieldDslMobile getFieldDslMobile() {
        return JsonUtil.objectToJavaObject(this.getFieldDsl(), FieldDslMobile.class);
    }

    /**
     * 是否显示在移动端
     *
     * @return
     */
    @JsonIgnore
    public boolean isDisplay() {
        FieldDslMobile fieldDslMobile = getFieldDslMobile();
        if (fieldDslMobile == null) {
            return false;
        }
        return BooleanUtils.isNotTrue(fieldDslMobile.getHidden());
    }

    @JsonIgnore
    public boolean isTitle() {
        FieldDslMobile fieldDslMobile = getFieldDslMobile();
        if (fieldDslMobile == null) {
            return false;
        }
        return "MAINTITLE".equals(fieldDslMobile.getType());
    }

    @JsonIgnore
    public boolean isSubTitle() {
        FieldDslMobile fieldDslMobile = getFieldDslMobile();
        if (fieldDslMobile == null) {
            return false;
        }
        return "SUBTITLE".equals(fieldDslMobile.getType());
    }

    @Data
    public static class FieldDslMobile {
        /**
         * 是否隐藏
         */
        private Boolean hidden = false;
        private String headerName;
        /**
         * { name: '主标题', type: 'MAINTITLE'},
         * { name: '子标题', type: 'SUBTITLE'},
         * { name: '电话号码', type: 'DW_MOBILE_TEL'},
         * {  name: '文本', type: 'LABEL'},
         * { name: '枚举', type: 'ENUM'},
         * { name: '图片拍照', type: 'DW_PICTURE'},
         * { name: '附件上传', type: 'FILE_UPLOAD'},
         * { name: '数值', type: 'NUMERICAL'},
         * { name: '标签', type: 'TAG'},
         */
        private String type;
        private String schema;
        private String path;
        // 不同type下，对应不同结构
        private Object setting;

        @Data
        public static class TitleObj {
            // 是否自定义标题
            private Boolean isCustomTitle = false;
            // 自定义标题
            private String title;
            private Object setting;
        }
    }
}
