package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

/**
 * 关键key
 *
 * @Author xujinc
 * @Version 1.0
 * @Date 2023/12/22 09:23
 */
public class PcUibotSupportKeyConstant {

    public static final String DESIGNER_PREFIX = "designer-" + PcUiBotConstants.WEB_PLATFORM;

    public static final String GENERAL_PAGE_TEMPLATE = "general-page-template";

    public static final String START_PROJECT_KEY = "start-project";

    public static final String VERSION_1 = "1.0";

    public static final String VERSION_2 = "2.0";

    public static final String DASHED = "-";

    private PcUibotSupportKeyConstant() {
    }

    /**
     * 低代码关键key
     */
    public static class Designer {

        private Designer() {
        }

        public static final String BUSINESS_DATA_ENTRY_DRIVEN = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_BUSINESS,
                PcUiBotActivityConstants.CATEGORY_DATA_ENTRY_DRIVEN,
                PcUiBotActivityConstants.PERFORMER
        ), DASHED).toLowerCase();

        public static final String BUSINESS_PROCESS = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_BUSINESS,
                PcUiBotActivityConstants.CATEGORY_PROCESS,
                PcUiBotActivityConstants.PERFORMER
        ), DASHED).toLowerCase();

        public static final String BUSINESS_APPROVAL = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_BUSINESS,
                PcUiBotActivityConstants.CATEGORY_APPROVAL,
                PcUiBotActivityConstants.PERFORMER
        ), DASHED).toLowerCase();

        public static final String BUSINESS_REPLY = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_BUSINESS,
                PcUiBotActivityConstants.CATEGORY_REPLY,
                PcUiBotActivityConstants.PERFORMER
        ), DASHED).toLowerCase();

        public static final String BUSINESS_SOLVE = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_BUSINESS,
                PcUiBotActivityConstants.CATEGORY_SOLVE,
                PcUiBotActivityConstants.PERFORMER
        ), DASHED).toLowerCase();

        public static final String CONDITION = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                PcUiBotActivityConstants.PATTERN_STATEMENT,
                GENERAL_PAGE_TEMPLATE
        ), DASHED).toLowerCase();

        public static final String START_PROJECT = StringUtils.join(Lists.newArrayList(
                DESIGNER_PREFIX,
                START_PROJECT_KEY,
                GENERAL_PAGE_TEMPLATE
        ), DASHED).toLowerCase();
    }

}
