package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;


/**
 * 每个数据源的查询结果，主要用来存储数据名，数据，元数据，数据索引
 */
public class QueryResult {
    /**
     * 数据节点名称
     */
    private String dataSourceName;
    /**
     * 是否为集合数据
     */
    private boolean single;

    public boolean isSingle() {
        return single;
    }

    public void setSingle(boolean single) {
        this.single = single;
    }

    /**
     * 分页属性:总数
     */
    private Integer totalResults;

    public Integer getTotalResults() {
        return totalResults;
    }

    public void setTotalResults(Integer totalResults) {
        this.totalResults = totalResults;
        if (totalResults == null) {
            this.hasNext = false;
        }
    }

    /**
     * 分页属性:是否有下一页
     */
    private boolean hasNext;

    public boolean isHasNext() {
        return hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    /**
     * 分页属性:每一页的大小，默认是50
     */
    private Integer pageSize = 50;

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


    /**
     * 第几页，默认是1
     */
    private Integer pageNo = 1;

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }


    /**
     * 查询的笔数
     */
    private Integer limit;

    public Integer getLimit() {
        return limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
        if (limit != null && !CollectionUtils.isEmpty(this.data) && this.data.size() > limit) {
            List<Map<String, Object>> newData = new ArrayList<>();
            for (int i = 0; i < limit; i++) {
                newData.add(this.data.get(i));
            }
            this.data = newData;
        }
    }

    /**
     * 数据结果集合
     */
    private List<Map<String, Object>> data;

    private PcUiBotApiMetadataCollection apiMetadataCollection;
    private List<PcUiBotApiMetadataCollection> apiMetadataCollectionList;

    private Map<String, Integer> dataKeyIndex;
    /**
     * 数据的key字段
     */
    private List<String> dataKeys;

    public List<String> getDataKeys() {
        return dataKeys;
    }

    public void setDataKeys(List<String> dataKeys) {
        this.dataKeys = dataKeys;
    }

    public static QueryResult empty() {
        QueryResult queryResult = new QueryResult();
        queryResult.setData(new ArrayList<>());
        queryResult.setDataKeyIndex(new HashMap<>());
        queryResult.setDataKeys(new ArrayList<>());
        return queryResult;
    }

    public static QueryResult empty(String dataSourceName) {
        return empty(dataSourceName, false);
    }

    /**
     * 空查询结果
     *
     * @param dataSourceName 数据源名称
     * @param single         是否为非数组
     * @return
     */
    public static QueryResult empty(String dataSourceName, boolean single) {
        QueryResult queryResult = new QueryResult();
        queryResult.setDataSourceName(dataSourceName);
        queryResult.setData(new ArrayList<>());
        queryResult.setDataKeyIndex(new HashMap<>());
        queryResult.setDataKeys(new ArrayList<>());
        return queryResult;
    }

    public static QueryResult withSingleData(String dataSourceName, Map<String, Object> data) {
        ArrayList dataList = new ArrayList<>();
        dataList.add(data);
        QueryResult queryResult = withData(dataSourceName, dataList);
        queryResult.setSingle(true);
        return queryResult;
    }

    public static QueryResult withData(String dataSourceName, Map<String, List<Object>> data) {
        List<Map<String, Object>> dataList = getMapFirstValueToList(data);
        if (StringUtils.isEmpty(dataSourceName) && data.size() > 0) {
            dataSourceName = (String) data.keySet().toArray()[0];
        }
        QueryResult queryResult = withData(dataSourceName, dataList);
        return queryResult;
    }

    public static List<Map<String, Object>> getMapFirstValueToList(Map<String, List<Object>> responseData) {
        List<Map<String, Object>> stdData = new ArrayList();
        Iterator var2 = responseData.entrySet().iterator();
        if (var2.hasNext()) {
            Map.Entry<String, List<Object>> entry = (Map.Entry) var2.next();
            ((List) entry.getValue()).forEach((item) -> {
                stdData.add((Map) item);
            });
        }

        return stdData;
    }

    public static QueryResult withData(String dataSourceName, List<Map<String, Object>> dataList) {
        QueryResult queryResult = new QueryResult();
        queryResult.setDataSourceName(dataSourceName);
        queryResult.setData(dataList);
        return queryResult;
    }

    public QueryResult withMetaData(PcUiBotApiMetadataCollection apiMetadataCollection) {
        this.setApiMetadataCollection(apiMetadataCollection);
        return this;
    }

    public QueryResult withDataIndex(Map<String, Integer> dataKeyIndex) {
        this.setDataKeyIndex(dataKeyIndex);
        return this;
    }

    public QueryResult appendData(QueryResult queryResult) {
        int oldSize = this.data.size();
        this.getData().addAll(queryResult.getData());
        Map<String, Integer> otherIndex = queryResult.getDataKeyIndex();
        otherIndex.forEach(((key, integer) -> {
            if (!this.dataKeyIndex.containsKey(key)) {
                this.dataKeyIndex.put(key, integer + oldSize);
            }
        }));
        return this;
    }

    public QueryResult resetData(List<Map<String, Object>> dataList) {
        this.data.clear();
        if (this.dataKeyIndex != null) {
            this.dataKeyIndex.clear();
        }
        this.data = dataList;
        return this;
    }


    public int size() {
        if (CollectionUtils.isEmpty(this.getData())) {
            return 0;
        }
        return this.getData().size();
    }

    public int keySize() {
        if (CollectionUtils.isEmpty(this.getDataKeyIndex())) {
            return 0;
        }
        return this.getDataKeyIndex().size();
    }

    public List<Map<String, Object>> getData() {
        return data;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
    }

    public PcUiBotApiMetadataCollection getApiMetadataCollection() {
        return apiMetadataCollection;
    }

    public void setApiMetadataCollection(PcUiBotApiMetadataCollection apiMetadataCollection) {
        this.apiMetadataCollection = apiMetadataCollection;
    }

    public List<PcUiBotApiMetadataCollection> getApiMetadataCollectionList() {
        return apiMetadataCollectionList;
    }

    private void setApiMetadataCollectionList(List<PcUiBotApiMetadataCollection> apiMetadataCollectionList) {
        this.apiMetadataCollectionList = apiMetadataCollectionList;
    }

    /**
     * 返回数据节点名称
     */
    public String getDataSourceName() {
        if (dataSourceName == null) {
            if (this.apiMetadataCollection != null
                    && this.apiMetadataCollection.getMasterApiMetadata() != null
                    && !CollectionUtils.isEmpty(this.apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
                dataSourceName = this.apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getName();
            } else {
                dataSourceName = "data";
            }
        }
        return dataSourceName;
    }

    /**
     * 获取api的response的单头字段，可以作为数据源名称使用
     *
     * @return 单头字段名，默认是data
     */
    public String getDataSourceNameFromApiResp() {
        if (this.apiMetadataCollection != null
                && this.apiMetadataCollection.getMasterApiMetadata() != null
                && !CollectionUtils.isEmpty(this.apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            dataSourceName = this.apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getName();
        } else {
            dataSourceName = "";
        }
        return dataSourceName;
    }

    /**
     * 获取单头元数据；respFields的第一个字段；
     *
     * @return 单头字段
     */
    public PcUiBotMetadataField getMasterField() {
        if (this.apiMetadataCollection != null
                && this.apiMetadataCollection.getMasterApiMetadata() != null
                && !CollectionUtils.isEmpty(this.apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            return this.apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0);
        }
        return null;
    }

    /**
     * 设置数据节点名称
     */
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public Map<String, Integer> getDataKeyIndex() {
        return dataKeyIndex;
    }

    private void setDataKeyIndex(Map<String, Integer> dataKeyIndex) {
        this.dataKeyIndex = dataKeyIndex;
    }

    public Map<String, Object> findByKey(String key) {
        if (this.dataKeyIndex == null) {
            return null;
        }
        if (StringUtils.isEmpty(key)) {
            return null;
        }

        if (this.dataKeyIndex.containsKey(key)) {
            Integer index = this.dataKeyIndex.get(key);
            return this.data.get(index);
        } else {
            return null;
        }
    }

    public Map<String, Object> getPageData() {
        Map<String, Object> pageData = new HashMap<>();
        if (this.single && !CollectionUtils.isEmpty(this.getData())) {
            pageData.put(dataSourceName, this.getData().get(0));
        } else {
            pageData.put(dataSourceName, this.getData());
        }
        return pageData;
    }

    public void initDataKeyIndex() {
        Map<String, Integer> dataKeyIndex = new HashMap<>();
        if (CollectionUtils.isEmpty(this.getData())
                || CollectionUtils.isEmpty(this.dataKeys)) {
            this.withDataIndex(dataKeyIndex);
            return;
        }
        int index = 0;
        for (Map<String, Object> datum : this.getData()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String key : dataKeys) {
                if (datum.containsKey(key)) {
                    stringBuilder.append(datum.get(key) == null ? "NAN" : datum.get(key).toString()).append(";");
                } else {
                    stringBuilder.append("NAN;");
                }
            }
            if (stringBuilder.length() > 0) {
                String key = stringBuilder.toString();
                datum.put(PcUiBotConstants.DATA_SOURCE_DATA_KEY, key);
                dataKeyIndex.put(key, index);
            }
            index++;

        }
        this.withDataIndex(dataKeyIndex);
    }

    public static QueryResult withData(String dataSourceName, Map<String, Object> data, PcUiBotPageInfo pageInfo) {
        QueryResult queryResult = null;
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            Object val = stringObjectEntry.getValue();
            if (val == null) {
                continue;
            }
            //获取数据源对应的API的值
            if (StringUtils.isEmpty(dataSourceName)) {
                dataSourceName = stringObjectEntry.getKey();
            }
            //多M结构，以数据源名称查询指定返回数组
            Object dataSourceVal = data.get(dataSourceName);
            if (data.size() > 1 && hasSourceVal(dataSourceVal)) {
                val = dataSourceVal;
            }
            if (val instanceof Collection) {
                List<Map<String, Object>> value = (List<Map<String, Object>>) val;
                queryResult = QueryResult.withData(dataSourceName, value);
                if (!CollectionUtils.isEmpty(value)) {
                    break;
                }
            } else if (val instanceof Map) {
                queryResult = QueryResult.withSingleData(dataSourceName, (Map<String, Object>) val);
                break;
            }
        }
        if (queryResult == null) {
            queryResult = QueryResult.empty(dataSourceName);
        }
        if (pageInfo != null && pageInfo.getPageNo() != null && pageInfo.getPageSize() != null) {
            queryResult.setPageSize(pageInfo.getPageSize());
            queryResult.setPageNo(pageInfo.getPageNo());
        }
        return queryResult;
    }

    public static boolean hasSourceVal(Object val) {
        if (val == null) {
            return false;
        }
        if (val instanceof Collection) {
            List<Map<String, Object>> value = (List<Map<String, Object>>) val;
            if (!CollectionUtils.isEmpty(value)) {
                return true;
            }
        } else if (val instanceof Map) {
            Map<String, Object> value = (Map<String, Object>) val;
            if (!CollectionUtils.isEmpty(value)) {
                return true;
            }
            return true;
        }
        return false;
    }

}
