package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>功能描述：鼎捷雅典娜PC UI Bot数据的Action模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotAction
 * @Author: Zaregoto
 * @Date: 2021/4/20 16:09
 */
public class UiBotAction extends HashMap<String, Object> {
    private static final long serialVersionUID = 6829960046326199314L;

    /**
     * 移动设计器submitAction唯一标识，关联使用 -- 移动设计器新增属性
     */
    private String uuid;
    /**
     * 移动设计器submitAction的btnId，相当于schema，提供给前端，作用于规则校验 -- 移动设计器新增属性
     */
    private String btnId;
    /**
     * 移动设计器动作类型,跳转页面/提交 -- 移动设计器新增属性
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.ButtonTypeEnum
     */
    private String btnType;
    /**
     * 移动设计器跳转类型，相关配置属性 -- 移动设计器新增属性
     */
    private UiBotJumpAction jumpAction;

    private String id;
    private String actionId;
    private List<UiBotAction> attachActions;
    private String category;
    /**
     * 是否是主要操作
     */
    private Boolean defaultAction;
    private Map<String, Object> serviceId;
    private UiBotActionSubmitType submitType;
    private String title;
    private String type;
    /**
     * API 透传的CONSTANT类型入参，不需要转换
     */
    private Map<String, Object> paras;
    private UiBotActionExtendParas extendParas;
    private String actionType;
    /**
     * 任务已关闭，是否还需要apply该action
     */
    private Boolean applyAlthoughFinished;

    /**
     * 打印的模板ID
     */
    private String printTemplateId;

    /**
     * 打印的模板Code
     */
    private String printTemplateCode;


    /**
     * API 入参 参数转换设定
     */
    private List<PcUiBotActionParameterMapping> actionParams;

    /**
     * 打印三期模板参数
     */
    private List<RelateTemplate> templates;

    @Data
    public static class RelateTemplate {
        /**
         * 引用的模版id
         */
        private String templateId;
        private List<PcUiBotActionParameterMapping> actionParams;
    }

    public UiBotAction() {
    }

    /**
     * 判断pc给的action类型是否是移动端支持转换的
     *
     * @return
     */
    public boolean isSupportedCategory() {
        return isWfCategory() || isEspCategory() || isTaskEngineCategory();
    }

    /**
     * 判断pc给的action类型是否是WF（Workflow系统，即流程引擎）类型
     *
     * @return
     */
    public boolean isWfCategory() {
        return "WF".equalsIgnoreCase(this.getCategory());
    }

    /**
     * 判断pc给的action类型是否是ESP（企业服务池，用于连接稳态数据）类型
     *
     * @return
     */
    public boolean isEspCategory() {
        return "ESP".equalsIgnoreCase(this.getCategory());
    }

    /**
     * 判断pc给的action类型是否是TaskEngine（任务引擎，用于管理任务全生命周期）类型
     *
     * @return
     */
    public boolean isTaskEngineCategory() {
        return "TaskEngine".equalsIgnoreCase(this.getCategory()) || "workflow".equalsIgnoreCase(this.getCategory());
    }

    /**
     * 获取PC端Action真实可用可判断的名称。
     * eg. agree,dispatch,reexecute,reapprove...
     *
     * @return
     */
    public String getUsefulActionServiceIdName() {
        String serviceIdName;
        String serviceIdNameKey = "name";
        List<UiBotAction> attachActions = this.getAttachActions();
        if (null != attachActions && !attachActions.isEmpty()) {
            Optional<UiBotAction> matchedAttachAction = attachActions.stream()
                    .filter(UiBotAction::isSupportedCategory)
                    .findFirst();
            if (matchedAttachAction.isPresent()) {
                serviceIdName = (String) matchedAttachAction.get().getServiceId().get(serviceIdNameKey);
            } else {
                serviceIdName = (String) this.getServiceId().get(serviceIdNameKey);
            }
        } else {
            serviceIdName = (String) this.getServiceId().get(serviceIdNameKey);
        }
        return StringUtil.valueOf(serviceIdName);
    }

    public String getActionServiceIdName() {
        Map<String, Object> map = this.getServiceId();
        return map == null || map.isEmpty() ? "" : StringUtil.valueOf(map.get("name"));
    }

    /**
     * 当前按钮对象是否是 同意 按钮
     *
     * @return
     */
    public boolean isAgreeAction(String serviceIdName) {
        if (!isSupportedCategory()) {
            return false;
        }
        String actionId = Optional.ofNullable(this.getActionId()).orElse("");
        String id = Optional.ofNullable(this.getId()).orElse("");
//        String serviceIdName = this.getUsefulActionServiceIdName();
        return actionId.equalsIgnoreCase("bpm_001")
                || actionId.equalsIgnoreCase("dispatch")
                //同意在提交的时候发现有这个参数值，但是生成按钮的时候退回按钮也是这个值，故先注释掉，待优化
//                || actionId.equalsIgnoreCase("esp_skill.mismatch.info.update")
                || serviceIdName.equalsIgnoreCase("agree")
                || serviceIdName.equalsIgnoreCase("dispatch")
                || serviceIdName.equalsIgnoreCase("skill.mismatch.info.update")
                || serviceIdName.equalsIgnoreCase("machine.shutdown.time.out.info.update")
                || serviceIdName.equalsIgnoreCase("day.energy.consume.abnormal.info.update")
                || serviceIdName.equalsIgnoreCase("workflow-act-agree")
                || "agree".equalsIgnoreCase(id)
                ;
    }

    /**
     * 当前按钮对象是否是 退回重签 按钮
     *
     * @return
     */
    public boolean isReapproveAction(String serviceIdName) {
        if (!isSupportedCategory()) {
            return false;
        }
        String actionId = Optional.ofNullable(this.getActionId()).orElse("");
//        String serviceIdName = this.getUsefulActionServiceIdName();
        return actionId.equalsIgnoreCase("reapprove")
                || actionId.equalsIgnoreCase("athena_bpm_reapprove")
                || serviceIdName.equalsIgnoreCase("reapprove");
    }

    /**
     * 当前按钮对象是否是 退回重办 按钮
     *
     * @return
     */
    public boolean isReexecuteAction(String serviceIdName) {
        if (!isSupportedCategory()) {
            return false;
        }
        String actionId = Optional.ofNullable(this.getActionId()).orElse("");
//        String serviceIdName = this.getUsefulActionServiceIdName();
        return actionId.equalsIgnoreCase("esp_fields.value.update")
                || actionId.equalsIgnoreCase("esp_po.temp.modify.process")
                || actionId.equalsIgnoreCase("esp_task.info.update")
                || actionId.equalsIgnoreCase("esp_machine.shutdown.time.out.info.update")
                || serviceIdName.equalsIgnoreCase("fields.value.update")
                || serviceIdName.equalsIgnoreCase("po.temp.modify.process")
                || serviceIdName.equalsIgnoreCase("task.info.update")
                || serviceIdName.equalsIgnoreCase("reexecute");
    }

    /**
     * 当前按钮对象是否是 转派 按钮
     *
     * @return
     */
    public boolean isReassignAction() {
        if (!isSupportedCategory()) {
            return false;
        }
        String actionId = Optional.ofNullable(this.getActionId()).orElse("");
//        String serviceIdName = this.getUsefulActionServiceIdName();
        return actionId.equalsIgnoreCase("reassign")
                || actionId.equalsIgnoreCase("athena_bpm_reassign");
    }

    /**
     * 当前按钮对象是否是 加签 按钮
     *
     * @return
     */
    public boolean isAddTaskAction() {
        if (!isSupportedCategory()) {
            return false;
        }
        String actionId = Optional.ofNullable(this.getActionId()).orElse("");
//        String serviceIdName = this.getUsefulActionServiceIdName();
        return actionId.equalsIgnoreCase("add-task")
                || actionId.equalsIgnoreCase("athena_bpm_add_task");
    }

    public String getActionId() {
        if (null != actionId) {
            return actionId;
        }
        return (String) super.get("actionId");
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public List<UiBotAction> getAttachActions() {
        if (null != attachActions) {
            return attachActions;
        }
        return JsonUtil.objectToJavaObject(super.get("attachActions"), new TypeReference<List<UiBotAction>>() {
        });
    }

    public void setAttachActions(List<UiBotAction> attachActions) {
        this.attachActions = attachActions;
    }

    public String getCategory() {
        if (null != category) {
            return category;
        }
        return (String) super.get("category");
    }

    public void setCategory(String category) {
        super.put("category", category);
        this.category = category;
    }

    public Boolean getDefaultAction() {
        if (null != defaultAction) {
            return defaultAction;
        }
        return (Boolean) super.get("defaultAction");
    }

    public void setDefaultAction(Boolean defaultAction) {
        this.defaultAction = defaultAction;
    }

    public Map<String, Object> getServiceId() {
        if (null != serviceId) {
            return serviceId;
        }
        return (Map<String, Object>) super.get("serviceId");
    }

    public void setServiceId(Map<String, Object> serviceId) {
        this.serviceId = serviceId;
    }

    public UiBotActionSubmitType getSubmitType() {
        if (null != submitType) {
            return submitType;
        }
        Map<String, Object> map = (Map<String, Object>) super.get("submitType");
        UiBotActionSubmitType submitType = new UiBotActionSubmitType();
        if (ObjectUtils.isNotEmpty(map)) {
            submitType.setIsBatch((Boolean) map.get("isBatch"));
            submitType.setSchema((String) map.get("schema"));
            submitType.setSubmitAll((Boolean) map.get("submitAll"));

        }
        return submitType;
    }

    public void setSubmitType(UiBotActionSubmitType submitType) {
        this.submitType = submitType;
        super.put("submitType", submitType);
    }

    public String getTitle() {
        if (null != title) {
            return title;
        }
        return (String) super.get("title");
    }

    public void setTitle(String title) {
        this.title = title;
        super.put("title", title);
    }

    public String getUuid() {
        if (null != uuid) {
            return uuid;
        }
        return (String) super.get("uuid");
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
        super.put("uuid", uuid);
    }

    public String getBtnId() {
        if (null != btnId) {
            return btnId;
        }
        return (String) super.get("btnId");
    }

    public void setBtnId(String btnId) {
        this.btnId = btnId;
        super.put("btnId", btnId);
    }

    public String getBtnType() {
        if (null != this.btnType) {
            return this.btnType;
        }
        return (String) super.get("btnType");
    }

    public void setBtnType(String btnType) {
        this.btnType = btnType;
        super.put("btnType", btnType);
    }

    public String getPrintTemplateId() {
        if (null != this.printTemplateId) {
            return this.printTemplateId;
        }
        return (String) super.get("printTemplateId");
    }

    public void setPrintTemplateId(String printTemplateId) {
        this.printTemplateId = printTemplateId;
        super.put("printTemplateId", printTemplateId);
    }

    public String getPrintTemplateCode() {
        if (null != this.printTemplateCode) {
            return this.printTemplateCode;
        }
        return (String) super.get("printTemplateCode");
    }

    public void setPrintTemplateCode(String printTemplateCode) {
        this.printTemplateCode = printTemplateCode;
        super.put("printTemplateCode", printTemplateCode);
    }

    public List<PcUiBotActionParameterMapping> getActionParams() {
        if (null != this.actionParams) {
            return this.actionParams;
        }
        return this.actionParams = JsonUtil.objectToJavaObject(super.get("actionParams"),
                new TypeReference<List<PcUiBotActionParameterMapping>>() {
                });
    }

    public void setActionParams(List<PcUiBotActionParameterMapping> actionParams) {
        this.actionParams = actionParams;
        super.put("actionParams", actionParams);
    }

    public List<RelateTemplate> getTemplates() {
        if (null != this.templates) {
            return this.templates;
        }
        return this.templates = JsonUtil.objectToJavaObject(super.get("templates"),
                new TypeReference<List<RelateTemplate>>() {
                });
    }

    public void setTemplates(List<RelateTemplate> templates) {
        this.templates = templates;
        super.put("templates", templates);
    }

    public UiBotJumpAction getJumpAction() {
        if (null != this.jumpAction) {
            return this.jumpAction;
        }
        return this.jumpAction = JsonUtil.objectToJavaObject(super.get("jumpAction"),
                new TypeReference<UiBotJumpAction>() {
                });
    }

    public void setJumpAction(UiBotJumpAction jumpAction) {
        this.jumpAction = jumpAction;
        super.put("jumpAction", jumpAction);
    }

    public String getId() {
        if (null != id) {
            return id;
        }
        return (String) super.get("id");
    }

    public void setId(String id) {
        this.id = id;
        super.put("id", id);
    }

    public String getType() {
        if (null != type) {
            return type;
        }
        return (String) super.get("type");
    }

    public void setType(String type) {
        super.put("type", type);
        this.type = type;
    }

    public Map<String, Object> getParas() {
        if (null != paras) {
            return paras;
        }
        return paras = super.get("paras") != null ? (Map<String, Object>) super.get("paras") : new HashMap<>();
    }

    public void setParas(Map<String, Object> paras) {
        super.put("paras", paras);
        this.paras = paras;
    }

    public UiBotActionExtendParas getExtendParas() {
        if (null != extendParas) {
            return extendParas;
        }
        return this.extendParas = JsonUtil.objectToJavaObject(super.get("extendParas"), new TypeReference<UiBotActionExtendParas>() {
        });

    }

    public void setExtendParas(UiBotActionExtendParas extendParas) {
        this.extendParas = extendParas;
        super.put("extendParas", extendParas);
    }

    public String getActionType() {
        if (null != actionType) {
            return actionType;
        }
        return (String) super.get("actionType");
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
        super.put("actionType", actionType);
    }

    public Boolean getApplyAlthoughFinished() {
        return applyAlthoughFinished;
    }

    public void setApplyAlthoughFinished(Boolean applyAlthoughFinished) {
        this.applyAlthoughFinished = applyAlthoughFinished;
    }
}
