package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：UiBot的业务字段基类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotBizFieldBase
 * @Author: zaregoto
 * @Date: 2023/3/1 16:37
 */
@Data
public abstract class UiBotBizFieldBase implements Serializable {
    private static final long serialVersionUID = 1118266552740676636L;

    /**
     * 业务字段ID
     */
    protected String schema;
    
    /**
     * 业务字段的数据类型
     */
    protected String dataType;

    /**
     * 业务字段的渲染组件类型
     */
    protected String type;


    public abstract boolean canEdit();

    public abstract void doSetCanEdit();

    public abstract void doSetCanNotEdit();

    public abstract void reverseEditableState();

    public abstract String getValueForDisplay(Map<String, Object> bizData);
}