package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.report.UiBotModelBuildApcStandProductionProgressPageStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.util.PcUiBotPatternUtil;
import com.digiwin.mobile.mobileuibot.task.strategy.custom.workreportinfo.TaskDetailBuildPccWorkReportInfoStrategy;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * <p>功能描述：移动设计器配置 跳转按钮点击事件对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotJumpAction.java
 * @Author: wangjwc
 * @Date: created at 2023/8/24 10:47
 */
@Data
@Accessors(chain = true)
public class UiBotJumpAction implements Serializable {
    private static final long serialVersionUID = -2841726007485926531L;

    /**
     * 是否可滑动查看其他页面详情
     */
    private Boolean detailPageSwiper = false;
    /**
     * 要跳转页面的页面id，此id是设计器随机生成的
     */
    private String jumpPageId;
    /**
     * 点击事件类型
     *
     * @see ActionTypeEnum
     */
    private Integer type;

    /**
     * 设计器设计的扩展字段 结构
     */
    private List<Map<String, String>> designExtendParameter;
    /**
     * 运行态的扩展字段结构
     */
    private UiBotDesignParameter designParameter;
    /**
     * 业务类型
     * 'local-delete'   |   'local-add'  |  'local-save'  |  'other' | ‘filter’
     *
     * @see BusinessTypeEnum
     */
    private String businessType;

    /**
     * 设计器配置定制提交JS
     */
    private String actionJsEvent;

    /**
     * line场景 整批提交前端保存 且显示（暂存(n/m)、保存并提交）为save 或 submit
     * 现只用于模型驱动下手动赋值
     */
    private String saveType;

    /**
     * 提交只给当前详情数据，默认全量数据（此场景目前只有PCC的问题处理任务卡，后续在有此场景需要设计器添加此字段配置）
     * 默认给全量数据
     */
    private Boolean submitAllData = true;

    /**
     * 二次弹窗 -- 设计器新增配置
     */
    private ConfirmPop confirmPop;

    /**
     * 按钮图标--卡片按钮和独立按钮
     */
    private String iconName = UibotIconNameEnum.SJQ_EMPTY.getValue();

    public UiBotDesignParameter getDesignParameter() {
        if (this.designParameter != null) {
            return this.designParameter;
        }
        if (!CollectionUtils.isEmpty(this.designExtendParameter)) {
            UiBotDesignParameter map = new UiBotDesignParameter();
            for (Map<String, String> stringObjectMap : this.designExtendParameter) {
                map.put(stringObjectMap.get("key"), stringObjectMap.get("value"));
            }
            this.designParameter = map;
        }
        return designParameter;
    }

    public String getJumpPageId() {
        return this.jumpPageId;
    }

    public Integer getType() {
        if (ActionTypeEnum.BACK.getValue().equals(this.type)
                && (BusinessTypeEnum.LOCAL_ADD.getValue().equalsIgnoreCase(this.businessType)
                || BusinessTypeEnum.LOCAL_SAVE.getValue().equalsIgnoreCase(this.businessType)
                || BusinessTypeEnum.LOCAL_DELETE.getValue().equalsIgnoreCase(this.businessType))) {
            return ActionTypeEnum.BACK_ONE_WITH_NO_REFRESH.getValue();
        } else if (ActionTypeEnum.BACK_AND_TRANSFER_DATA_TO_PREFIX.getValue().equals(this.type)
                && (BusinessTypeEnum.LOCAL_ADD.getValue().equalsIgnoreCase(this.businessType)
                || BusinessTypeEnum.LOCAL_SAVE.getValue().equalsIgnoreCase(this.businessType)
                || BusinessTypeEnum.LOCAL_DELETE.getValue().equalsIgnoreCase(this.businessType))) {
            // 本地操作，因设计器勾选了携带参数，导致类型为411，故强制转换成401
            return ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue();
        }
        return this.type;
    }

    /**
     * 配置返回页面时需要重新设置pageId值，提供给前端刷新和跳转
     * 注意：只在button类中调用(因设置返回操作都是在按钮中配置)，其它类中直接调用getJumpPageId()方法即可
     *
     * @param executeContext
     * @return
     */
    public String getJumpPageId(PcUiBotExecuteContext executeContext) {
        if (!StringUtils.hasLength(this.jumpPageId)) {
            return jumpPageId;
        }
        if (executeContext != null && PcUiBotPatternUtil.isBaseData(executeContext.getPattern())) {
            // 基础资料录入
            if (this.jumpPageId.endsWith("page1")) {
                if (UiBotDesignerService.PAGECODE_BASIC_DATA.equals(executeContext.getPageCode())) {
                    this.jumpPageId = PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name();
                } else if (UiBotDesignerService.PAGECODE_BROWSE_PAGE.equals(executeContext.getPageCode())) {
                    this.jumpPageId = PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name();
                } else if (UiBotDesignerService.PAGECODE_EDIT_PAGE.equals(executeContext.getPageCode())) {
                    this.jumpPageId = PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_EDIT_PAGE.name();
                }
            }
        } else if (executeContext != null && PcUiBotActivityConstants.Category.START_PROJECT.equalsIgnoreCase(executeContext.getCategory())) {
            // 发起项目
            if (this.jumpPageId.endsWith("page1")) {
                this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.name();
            }
        } else if (executeContext != null && Objects.equals(TaskDetailBuildPccWorkReportInfoStrategy.getTmactivityid(), executeContext.getTmActivityId())) {
            // 报工查询
            if (this.jumpPageId.endsWith("page1")) {
                this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_PCC_WORK_REPORT_INFO_PAGE.name();
            }
        } else if (executeContext != null && Objects.equals(UiBotModelBuildApcStandProductionProgressPageStrategy.getTmActivityId(), executeContext.getTmActivityId())) {
            // APC-机位生产进度页面
            if (this.jumpPageId.endsWith("page1")) {
                this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_APC_STAND_PRODUCTION_PROGRESS_PAGE.name();
            }
        } else if (executeContext != null && PcUiBotPatternUtil.isWorkBench(executeContext.getPattern())) {
            // 移动工作台
            if (this.jumpPageId.endsWith("page1")) {
                if (UiBotDesignerService.PAGECODE_WORKBENCH.equals(executeContext.getPageCode())) {
                    this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_WORKBENCH_PAGE.name();
                }
            }
        } else if (executeContext != null && PcUiBotActivityConstants.CHARGE.equals(executeContext.getIdentity())) {
            // 任务卡当责者
            if (this.jumpPageId.endsWith("page1")) {
                if (UiBotDesignerService.PAGECODE_PROJECT_DETAIL.equals(executeContext.getPageCode())) {
                    this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_MILESTONE_PAGE.name();
                }
            }
        } else {
            // 其它
            if (this.jumpPageId.endsWith("page1")) {
                // wjw FIXME: 2023/9/11 设计器默认主页面的pageId是以page1结尾，故可以根据page1来判断是否主页面，如果是主页面需要替换成进入任务卡详情时的pageId
                this.jumpPageId = PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name();
            }
        }
        return jumpPageId;
    }

    /**
     * 移动设计器新增属性：
     * 当前按钮是否会经过界面上动态业务规则的校验
     * 如果true，会经过校验，校验为通过则按钮会高亮且可点击；反之则不高亮且不可点击
     * 如果false，界面不会校验当前按钮，按钮初始为会是高亮可点击
     */
    private Boolean isCheckButton;
    /**
     * 移动设计器按钮样式类型配置
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum
     */
    private Integer btnStyleType;
    /**
     * 不是从设计器配置的，是手动存入的数据
     */
    private Map<String, Object> rawData;
    /**
     * 不是从设计器配置的，是手动存入的数据
     * 娜娜消息ID，主要作用是APP中娜娜打开数据驱动任务卡，确定是否提交，提交的是哪个消息
     */
    private String nanaMessageId;
    /**
     * 是否展示按钮名称后面数字
     */
    private Boolean showNum;
    /**
     * 设计器非按钮组件（如：卡片下按钮）对应的组件id --- 构建按钮组时需要赋值给按钮组件 --- 作用于配置高级属性
     */
    private String componentId;

    /**
     * 底部按钮是否走签核按钮定制页面 fasle走V1标准页面，true走设计器拖拉页面,默认false
     */
    private Boolean isCustomizedApprovalButton = false;
}