package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import lombok.Getter;

/**
 * <p>功能描述：移动设计器配置 跳转按钮点击事件类型枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotJumpActionTypeEnum.java
 * @Author: wangjwc
 * @Date: created at 2023/8/24 10:55
 */
@Getter
@Deprecated
public enum UiBotJumpActionTypeEnum {
    /**
     * 开新页面      不携参   1
     */
    OPEN_NEW_PAGE_WITH_NO_PARAMETER(1),
    /**
     * 开新页        携参    14
     */
    OPEN_NEW_PAGE_WITH_PARAMETER(14),
    /**
     * 开窗         不携参   2
     */
    OPEN_NEW_WINDOW_WITH_NO_PARAMETER(2),
    /**
     * 开窗         携参    24
     */
    OPEN_NEW_WINDOW_WITH_PARAMETER(24),
    /**
     * 311：调用接口，成功后跳转到下一个页签
     */
    CALL_API_AND_JUMP_NEXT_PAGE(311),
    /**
     * 返回        不携参    不刷新   4
     */
    RETURN_WITH_NO_PARAMETER_AND_NEVER_REFRESH(4),

    /**
     * 返回        不携参    刷新     401-----------若没有pageId返回上一页，有pageId返回指定页
     */
    RETURN_WITH_NO_PARAMETER_AND_REFRESH(401),

    /**
     * 返回        不携参    不刷新     4011
     */
    RETURN_WITH_NO_PARAMETER_AND_NO_REFRESH(4011),

    /**
     * 返回        携参     不刷新    44
     */
    RETURN_WITH_PARAMETER_AND_NEVER_REFRESH(44),

    /**
     * 返回       携参      刷新     441--------新增的，根据pageId，返回到指定页面
     */
    RETURN_WITH_PARAMETER_AND_REFRESH(441),

    /**
     * 45：跳转到下一个页签，保存当前页面参数
     */
    SAVE_CURRENT_PARAMETERS_AND_JUMP_NEXT_PAGE(45),

    ;

    private final Integer value;

    UiBotJumpActionTypeEnum(Integer value) {
        this.value = value;
    }
}
