package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：UI Bot数据的PageData模型</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotPageData
 * @Author: Zaregoto
 * @Date: 2021/4/20 16:06
 */
public class UiBotPageData extends HashMap<String, Object> implements Serializable {
    private static final long serialVersionUID = -937950059284699902L;

    public UiBotPageData(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public UiBotPageData(int initialCapacity) {
        super(initialCapacity);
    }

    public UiBotPageData() {
    }

    public UiBotPageData(Map<? extends String, ?> m) {
        super(m);
    }

    public Map<String, Object> getUiBotActivity() {
        if (this.containsKey("uiBot__activity")) {
            return (Map<String, Object>) this.get("uiBot__activity");
        } else {
            return Collections.emptyMap();
        }
    }

    public Map<String, Object> getUiBotApprovalDescription() {
        if (this.containsKey("uiBot__APPROVAL_DESCRIPTION")) {
            return (Map<String, Object>) this.get("uiBot__APPROVAL_DESCRIPTION");
        } else {
            return Collections.emptyMap();
        }
    }

    public Map<String, Object> getUiBotGlobalParameter() {
        if (this.containsKey("uibot__global_parameter")) {
            return (Map<String, Object>) this.get("uibot__global_parameter");
        } else {
            return Collections.emptyMap();
        }
    }

    /**
     * 根据入参的key，递归获取实际业务资料对象，支持多层级key
     *
     * @param key 业务对象的key，支持多层级，如purchase_temp.purchase_temp_detail
     * @return
     */
    @Override
    public Object get(Object key) {
        if (ObjectUtils.isEmpty(key)) {
            return null;
        }
        if (super.get(key) != null) {
            return super.get(key);
        }
        if (key instanceof String) {
            String keyStr = (String) key;
            if (keyStr.contains(".")) {
                String[] keys = keyStr.split("\\.");
                UiBotPageData pageData = this;
                for (int i = 0; i < keys.length - 1; i++) {
                    pageData = JsonUtil.objectToJavaObject(pageData.get(keys[i]), UiBotPageData.class);
                    if (pageData == null) {
                        return null;
                    }
                }
                return pageData.get(keys[keys.length - 1]);
            }
        }
        return null;
    }

    /**
     * 根据UiBotLayout中的path（可能有）和schema获取待处理的业务资料<br/>
     * 如果hasParentSchema为true，则表示当前UiBotPageData已经是下一层资料，故不会使用path字段，直接使用schema字段查找；<br/>
     * 反之则使用path字段查找<br/>
     * 业务资料按ESP规范，从第一层往下分别是：M层、D层、SD层等。若待取资料是M层，则不会有path；其他情况都会有path，且path多层级使用"."进行分割
     *
     * @param path            待查找的path字段
     * @param schema          待查找的schema字段
     * @param hasParentSchema 是否有父布局组件对应的schema字段
     * @return
     */
    public Object getBizDataByPathAndSchema(String path, String schema, boolean hasParentSchema) {
        if (hasParentSchema) {
            return this.get(schema);
        }
        if (StringUtils.hasLength(path) && StringUtils.hasLength(schema)) {
            return this.get(path + "." + schema);
        } else if (!StringUtils.hasLength(path) && StringUtils.hasLength(schema)) {
            return this.get(schema);
        } else {
            return new Object();
        }
    }
}
