package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapperJsonDeserializer;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroupAlignEnum;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 动态渲染V2-DSL
 *
 * @author zhangjj
 * @date 2023/2/15 13:55
 */
@Data
public class UiBotRenderData implements Serializable {
    private static final long serialVersionUID = -1983364667929797318L;
    /**
     * 与开发平台设计器集成后引入该字段，用于标识页面的唯一性，提供前端，用于规则处理
     */
    private String schema = UUIDUtil.getUuid();
    /**
     * 画面头部组件list（固定不动）
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> header;

    /**
     * 画面身体部分组件list（可动）
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> body;

    /**
     * 画面底部组件list（固定不动）
     */
    @JsonDeserialize(contentUsing = BaseMobileComponentWrapperJsonDeserializer.class)
    private List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom;

    private UiBotRenderData() {
    }

    public static UiBotRenderData createEmptyRenderData() {
        UiBotRenderData uiBotRenderData = new UiBotRenderData();
        uiBotRenderData.setHeader(new ArrayList<>());
        uiBotRenderData.setBody(new ArrayList<>());
        uiBotRenderData.setBottom(new ArrayList<>());
        return uiBotRenderData;
    }

    public void addWrapperedComponentToHeader(BaseMobileComponentWrapper<BaseMobileComponent> wrapperedComponent) {
        if (null != this.getHeader()) {
            this.getHeader().add(wrapperedComponent);
        }
    }

    public void addWrapperedComponentListToHeader(List<BaseMobileComponentWrapper<BaseMobileComponent>> wrapperedComponentList) {
        if (null != this.getHeader()) {
            this.getHeader().addAll(wrapperedComponentList);
        }
    }

    public void addWrapperedComponentToBody(BaseMobileComponentWrapper<BaseMobileComponent> wrapperedComponent) {
        if (null != this.getBody()) {
            this.getBody().add(wrapperedComponent);
        }
    }

    public void addEmptyComponentToBody() {
        if (null != this.getBody()) {
            this.getBody().add(createEmptyWrapper());
        }
    }

    public void addWrapperedComponentListToBody(List<BaseMobileComponentWrapper<BaseMobileComponent>> wrapperedComponentList) {
        if (null != this.getBody()) {
            this.getBody().addAll(wrapperedComponentList);
        }
    }

    public void addWrapperedComponentToBottom(BaseMobileComponentWrapper<BaseMobileComponent> wrapperedComponent) {
        if (null != this.getBottom()) {
            this.getBottom().add(wrapperedComponent);
        }
    }

    /**
     * 重置底部按钮，只增加取消按钮
     */
    public void resetCancelComponentToBottom() {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> bottom = new ArrayList<>();
        this.setBottom(bottom);

        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setAlignmentType(ButtonGroupAlignEnum.CENTER.getValue());
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper =
                new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE);

        bottom.add(componentWrapper);

        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        buttonGroup.setContentGroup(contentGroup);

        contentGroup.add(new BaseMobileComponentWrapper<>(BottomButtonDigiwinAthena.createNormalCancelButton(AppRequestContext.getContextEntity().getLocale()), "DW_" + Button.COMPONENT_TYPE));
    }

    public void addWrapperedComponentListToBottom(List<BaseMobileComponentWrapper<BaseMobileComponent>> wrapperedComponentList) {
        if (null != this.getBottom()) {
            this.getBottom().addAll(wrapperedComponentList);
        }
    }

    public static BaseMobileComponentWrapper<BaseMobileComponent> createEmptyWrapper() {
        return new BaseMobileComponentWrapper<>(
                Empty.create(LocaleUtil.getMobileTextByKey(AppRequestContext.getContextEntity().getLocale(), "暂无数据"), true),
                "DW_" + Empty.COMPONENT_TYPE);
    }
}
