package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;

import java.io.Serializable;

/**
 * <p>功能描述：UiBot返回数据中搜索到的目标Layout</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotTargetLayoutSearchResult
 * @Author: Zaregoto
 * @Date: 2021/12/22 20:24
 */
public class UiBotTargetLayoutSearchResult implements Serializable {

    private Integer targetUiBotLayoutIdx;
    private UiBotLayout targetUiBotLayout;
    private Boolean hasCustomData;

    public UiBotTargetLayoutSearchResult() {
    }

    public static UiBotTargetLayoutSearchResult create(int targetUiBotLayoutIdx,
        UiBotLayout targetUiBotLayout, boolean hasCustomData) {
        UiBotTargetLayoutSearchResult result = new UiBotTargetLayoutSearchResult();
        result.setTargetUiBotLayoutIdx(targetUiBotLayoutIdx);
        result.setTargetUiBotLayout(targetUiBotLayout);
        result.setHasCustomData(hasCustomData);

        return result;
    }

    public boolean found() {
        return targetUiBotLayoutIdx > -1 && null != targetUiBotLayout;
    }

    public Integer getTargetUiBotLayoutIdx() {
        return targetUiBotLayoutIdx;
    }

    public void setTargetUiBotLayoutIdx(Integer targetUiBotLayoutIdx) {
        this.targetUiBotLayoutIdx = targetUiBotLayoutIdx;
    }


    public UiBotLayout getTargetUiBotLayout() {
        return targetUiBotLayout;
    }

    public void setTargetUiBotLayout(UiBotLayout targetUiBotLayout) {
        this.targetUiBotLayout = targetUiBotLayout;
    }

    public Boolean getHasCustomData() {
        return hasCustomData;
    }

    public void setHasCustomData(Boolean hasCustomData) {
        this.hasCustomData = hasCustomData;
    }
}
