package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：任务卡内容提示说明配置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotTipSetting.java
 * @Author: wangjwc
 * @Date: created at 2023/8/21 13:55
 */
@Data
public class UiBotTipSetting {
    // 内容提示字段配置
    List<TipSettingElement> content;
    // 数据源配置
    Map<String, PcUiBotTmQueryAction> dataSources;

    @Data
    public static class TipSettingElement {
        private String label;
        private String schema;
        @JsonProperty("data_name")
        @JSONField(name = "data_name")
        private String dataName;
        private Map<String, Object> description;
        private String fullPath;

        public String getLabel() {
            if (CollectionUtils.isEmpty(this.description)) {
                return label;
            }
            Object o = description.get(AppRequestContext.getContextEntity().getLocale());
            return StringUtil.valueOf(o);
        }
    }
}
