package com.digiwin.mobile.mobileuibot.proxy.uibot.model;

import java.util.Objects;

/**
 * 页面类型的枚举类
 */
public enum UibotModelTypeEnum {

    DEFAULT_PAGE_MODEL(0),
    /**
     * 任务卡类型的model
     */
    TASK_PAGE_MODEL(1),
    ;
    private final Integer value;

    UibotModelTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static UibotModelTypeEnum getEnumByValue(String value) {
        for (UibotModelTypeEnum testedEnum : UibotModelTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }


}
