package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import java.util.Objects;

/**
 * <p>功能描述：敏捷数据——字符串类型常量枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataConstStringEnum
 * @Author: zaregoto
 * @Date: 2023/12/19 21:53
 */
public enum AgileDataConstStringEnum {
    /**
     * 娜娜助理，无法从敏捷数据生成移动组件时的回复提示
     */
    AI_ASSISTANT_NO_DATA_REPLY("很抱歉，数据呈现出现异常，请稍后再试"),

    /**
     * 直接进详情页面，无法从敏捷数据生成移动组件时的回复提示
     */
    DETAIL_PAGE_NO_DATA_REPLY("很抱歉，数据呈现出现异常，请稍后再试"),
    ;

    private final String value;

    AgileDataConstStringEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AgileDataConstStringEnum getEnumByValue(String value) {
        for (AgileDataConstStringEnum testedEnum : AgileDataConstStringEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
