package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotStyle;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：敏捷数据组件提供的中间态DSL</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataIntermediateDsl
 * @Author: zaregoto
 * @Date: 2023/11/20 19:18
 */
@Data
@Accessors(chain = true)
public class AgileDataIntermediateDsl implements Serializable {

    private static final long serialVersionUID = 2768386821007848314L;

    private List<AgileDataIntermediateLayout> layout;
    private UiBotPageData pageData;
    private UiBotPageData pageDataIndex;
    private UiBotPageData pageDataKeys;
    private List<UiBotRule> rules;
    private UiBotStyle style;
    private UiBotExecuteContext executeContext;

    private Integer pageCountSize;

    //敏捷数据使用，数据提示信息
    private String dataTipMessage;

    /*********************************************************************************************
     * ******************************** 移动端特有属性 BEGIN ***************************************
     *********************************************************************************************/
    /**
     * 只有v2版本的DSL时增加,前端使用
     */
    private UiBotPageData rawUiBotPageData;

    /**
     * 错误信息（从DigiwinAthenaApiResponse中获得并设置）
     */
    private String errorMessage;

    /*********************************************************************************************
     * ******************************** 移动端特有属性 END ***************************************
     *********************************************************************************************/

    public boolean isEmpty() {
        return null == this.layout || null == executeContext;
    }
}