package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：敏捷数据的字段元数据定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataMetadataField
 * @Author: zaregoto
 * @Date: 2023/11/20 19:18
 */
@Data
public class AgileDataMetadataField implements Serializable {

    private static final long serialVersionUID = 5554615307803572859L;
    
    /**
     * 字段ID
     */
    private String name;

    /**
     * 字段名称
     */
    private String description;

    /**
     * 字段数据类型
     */
    private String dataType;
    /**
     * 是否支持排序
     */
    private Boolean canSort;
    /**
     * 是否支持筛选
     */
    private Boolean canFilter;
    /**
     * 是否支持编辑
     */
    private Boolean canEdit;

    /**
     * 子字段
     */
    private List<AgileDataMetadataField> subFields;
}