package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import java.util.Objects;

/**
 * <p>功能描述：敏捷数据——呈现分类枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataShowCategoryEnum
 * @Author: zaregoto
 * @Date: 2023/11/20 19:35
 */
public enum AgileDataShowCategoryEnum {
    /**
     * 以表格方式呈现
     */
    TABLE(0),

    /**
     * 以图表方式呈现
     */
    CHART(1),
    /**
     * 以统计指标方式呈现
     */
    STATISTIC(2),
    ;

    private final Integer value;

    AgileDataShowCategoryEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static AgileDataShowCategoryEnum getEnumByValue(Integer value) {
        for (AgileDataShowCategoryEnum testedEnum : AgileDataShowCategoryEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
