package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

/**
 * <p>功能描述：Web端动态布局对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WebDynamicLayout
 * @Author: zaregoto
 * @Date: 2023/11/20 19:18
 */
@Data
public class WebDynamicLayout implements Serializable {

    private static final long serialVersionUID = 9122619168772525776L;

    /**
     * 布局类型
     */
    private String type;

    /**
     * 若web端使用layout.type=FLEX，才会有这个字段。
     * 该字段用于说明group的内容是以行，还是列的方向摆放
     *
     * @see WebFlexLayoutDirectionEnum
     */
    private String direction;
    /**
     * 宽度。
     * 支持百分比写法，如90%
     */
    private String layoutWidth;

    /**
     * 高度。
     * 支持百分比写法，如90%
     */
    private String layoutHeight;
    private String dataType;
    private List<WebDynamicLayout> group;

    /**
     * 若web端使用layout.type=GRIDSTER，才会有这个字段。
     * 该字段用于标记数据在每个区域的大小和位置
     */
    private List<WebGridsterLayoutDashboard> items;

    /**
     * 当前布局关联的业务数据ID，用于关联数据与布局
     */
    private String bizDataId;

    public enum Direction {
        ROW("ROW"),
        COLUMN("COLUMN"),

        ;

        private final String value;

        Direction(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        public static WebFlexLayoutDirectionEnum getEnumByValue(String value) {
            for (WebFlexLayoutDirectionEnum testedEnum : WebFlexLayoutDirectionEnum.values()) {
                if (Objects.equals(testedEnum.getValue(), value)) {
                    return testedEnum;
                }
            }
            return null;
        }
    }
}