package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata;

import java.util.Objects;

/**
 * <p>功能描述：Web端FLEX类型布局方向枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: WebDynamicLayoutDirectionEnum
 * @Author: zaregoto
 * @Date: 2023/11/20 19:28
 */
public enum WebFlexLayoutDirectionEnum {
    ROW("ROW"),
    COLUMN("COLUMN"),

    ;

    private final String value;

    WebFlexLayoutDirectionEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static WebFlexLayoutDirectionEnum getEnumByValue(String value) {
        for (WebFlexLayoutDirectionEnum testedEnum : WebFlexLayoutDirectionEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
