package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Optional;

/**
 * <p>功能描述：敏捷数据——图表字段展示格式化配置对象</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataChartFieldDisplayFormat
 * @Author: zaregoto
 * @Date: 2023/12/19 20:07
 */
@Data
@Accessors(chain = true)
@Slf4j
public class AgileDataChartFieldDisplayFormat implements Serializable {

    public static final Integer DEFAULT_DECIMAL = 2;

    public static final String FORMAT_PERCENT = "percent";

    public static final String FORMAT_THOUSAND = "thousand";

    /**
     * 字段值是否需要使用百分号，或千分位显示
     * 当使用百分号时，值为percent；
     * 当使用千分位时，值为thousand
     */
    private String percent;

    /**
     * 统计指标的显示精度
     */
    private Integer decimal;

    /**
     * 舍入方式
     */
    private UiBotTableDecimalRule decimalRule;

    /**
     * 计算单位
     */
    private UiBotTableUnit unit;

    /**
     * 根据格式中的配置，返回一个用于格式化输出数值的格式字符串
     *
     * @param d 待格式化展示的浮点数
     * @return
     */
    public String getFormattedString(final Double d) {
        double newValue;
        if (null == d) {
            log.debug("value is null, set to ZERO...");
            newValue = 0D;
        } else {
            newValue = d;
        }
        String percent = Optional.ofNullable(this.percent).map(String::toLowerCase).map(String::trim).orElse("");

        // 定义误差值epsilon。如果传入值的绝对值小于误差值，则认为是零
        double epsilon = 1e-9;
        double absNewValue = Math.abs(newValue);
        if (absNewValue < epsilon) {
            newValue = 0.0;
        }
        if (FORMAT_PERCENT.equals(percent)) {
            if (null == this.decimal) {
                return String.format("%." + DEFAULT_DECIMAL + "f%%", newValue * 100.0);
            } else {
                return String.format("%." + decimal + "f%%", newValue * 100.0);
            }
        } else if (FORMAT_THOUSAND.equals(percent)) {
            if (null == this.decimal) {
                return String.format("%,." + DEFAULT_DECIMAL + "f", newValue);
            } else {
                return String.format("%,." + decimal + "f", newValue);
            }
        } else {
            if (null == this.decimal) {
                return String.format("%." + DEFAULT_DECIMAL + "f", newValue);
            } else {
                return String.format("%." + decimal + "f", newValue);
            }
        }
    }
}