package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart;

import java.util.Objects;

/**
 * <p>功能描述：敏捷数据——图表标线功能类型枚举</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataChartMarkLineFunTypeEnum
 * @Author: zaregoto
 * @Date: 2024/1/23 19:57
 */
public enum AgileDataChartMarkLineFunTypeEnum {
    /**
     * 平均值
     */
    AVG("average"),

    /**
     * 最小值
     */
    MIN("min"),

    /**
     * 最大值
     */
    MAX("max"),
    ;

    private final String value;

    AgileDataChartMarkLineFunTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AgileDataChartMarkLineFunTypeEnum getEnumByValue(String value) {
        for (AgileDataChartMarkLineFunTypeEnum testedEnum : AgileDataChartMarkLineFunTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
