package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：敏捷数据——图表类呈现统计字段（或叫度量字段）数据</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataChartValueField
 * @Author: zaregoto
 * @Date: 2023/11/20 19:18
 */
@Data
public class AgileDataChartValueField extends AgileDataChartBaseField {

    private static final long serialVersionUID = 4670203115204323408L;
    /**
     * 当前字段使用的图表类型
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum
     */
    private String chartType;

    /**
     * 字段路径
     */
    private String path;

    /**
     * 字段名称，如customerName
     */
    private String name;

    /**
     * 字段展示标题，如客户名称
     */
    private String title;

    /**
     * 字段数据类型
     */
    private String dataType;

    /**
     * 当前字段所在的分组编号，从0开始的正整数
     * 默认值：0。若中间态DSL未出现该字段，表示没做分组，则所有统计字段（或叫度量字段）默认为一组。
     */
    private Integer group = 0;

    /**
     * 度量字段的颜色索引，从0开始的正整数
     * 使用当前字段在度量字段数组中的索引值
     */
    @JsonIgnore
    @JSONField(serialize = false, deserialize = false)
    private Integer colorIdx;

    /**
     * 指标单位
     */
    private String businessType;

    /**
     * 数据计算逻辑说明
     */
    private String description;

    /**
     * 用户筛选维度条件
     */
    private List<AgileDataAnalysisData> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AgileDataAnalysisData> measurementData;

    public List<AgileDataAnalysisData> getMeasurementData(JSONObject pageDatum) {
        return getAgileDataAnalysisData(pageDatum, measurementData);
    }

    public List<AgileDataAnalysisData> getDimensionData(JSONObject pageDatum) {
        return getAgileDataAnalysisData(pageDatum, dimensionData);
    }

    @NotNull
    private List<AgileDataAnalysisData> getAgileDataAnalysisData(JSONObject pageDatum, List<AgileDataAnalysisData> dimensionData) {
        List<AgileDataAnalysisData> list = new ArrayList<>();
        for (AgileDataAnalysisData analysisData : dimensionData) {
            AgileDataAnalysisData data = new AgileDataAnalysisData();
            data.setName(analysisData.getName());
            data.setValue(pageDatum.get(analysisData.getDataKey()));
            data.setDataKey(analysisData.getDataKey());
            list.add(data);
        }
        return list;
    }
}