package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.AgileDataChartMeasurePresentJsonDeserializer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure.MeasurePresent;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.util.List;

/**
 * <p>功能描述：敏捷数据——图表类呈现设置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ChartRenderSetting
 * @Author: zaregoto
 * @Date: 2023/11/20 19:18
 */
@Data
public class ChartRenderSetting implements AgileDataRenderSetting {
    private static final long serialVersionUID = -3346852140497083711L;

    private String title;

    /**
     * 图表类型
     *
     * @see com.digiwin.mobile.mobileuibot.core.component.chart.ChartTypeEnum
     */
    private String chartType;

    /**
     * 维度字段
     */
    private List<AgileDataChartPointField> points;

    /**
     * 统计字段
     */
    private List<AgileDataChartValueField> values;

    /**
     * 图表标线
     */
    private AgileDataChartMarkLine markLine;

    /**
     * 度量呈现配置
     */
    @JsonDeserialize(contentUsing = AgileDataChartMeasurePresentJsonDeserializer.class)
    private List<MeasurePresent> measurePresents;

    /**
     * 是否有堆叠（截止2024.04仍未有场景使用）
     */
    private Boolean useStack;

    /**
     * 散点图和气泡图使用此字段直接返回,和Pc端共用EChats结构，移动端不做额外的处理
     */
    private Object option;
}