package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Objects;

/**
 * <p>功能描述：图表坐标抽象类的反序列化处理器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AgileDataChartMeasurePresentJsonDeserializer
 * @Author: zaregoto
 * @Date: 2024/1/24 21:47
 */
@Slf4j
public class AgileDataChartMeasurePresentJsonDeserializer extends JsonDeserializer<MeasurePresent> {

    @Override
    public MeasurePresent deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        log.debug("AgileDataChartMeasurePresentJsonDeserializer activated!!!");
        JsonNode node = jsonParser.getCodec().readTree(jsonParser);
        JsonNode formulationIdNode = node.get("formulationId");

        MeasurePresent measurePresent = null;
        if (formulationIdNode instanceof TextNode) {
            String formulationId = formulationIdNode.asText();
            if (Objects.equals(GrowthRateMeasurePresent.FORMULATION_ID, formulationId.toLowerCase())) {
                measurePresent = new GrowthRateMeasurePresent();
                measurePresent.setFormulationId(formulationId);

                JsonNode paramsNode = node.get("params");
                GrowthRateParams params = new GrowthRateParams()
                        .setApplyToField(paramsNode.get("applyToField").asText());
                measurePresent.setParams(params);

                AgileDataChartFieldDisplayFormat format = new AgileDataChartFieldDisplayFormat();
                JsonNode formatNode = node.get("format");
                if (null == formatNode || formatNode.isEmpty()) {
                    format.setDecimal(AgileDataChartFieldDisplayFormat.DEFAULT_DECIMAL)
                            .setPercent(AgileDataChartFieldDisplayFormat.FORMAT_PERCENT);
                } else {
                    format.setDecimal(formatNode.get("decimal").asInt())
                            .setPercent(formatNode.get("percent").asText());
                }
                measurePresent.setFormat(format);
            } else {
                measurePresent = new NotSupportedMeasurePresent();
            }
        }
        return measurePresent;
    }
}
