package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;

import java.util.List;

/**
 * <p>功能描述：增长率度量呈现解释器</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: GrowthRateInterpreter
 * @Author: zaregoto
 * @Date: 2024/1/24 21:16
 */
public class GrowthRateInterpreter implements MeasurePresentInterpreter<GrowthRateMeasurePresent, GrowthRateInterpreterResult> {

    private static final String FORMULATION = "(${nowField} - ${previousField}) / ${previousField} * 100%";

    @Override
    public GrowthRateInterpreterResult interpret(JSONObject pageDataJsonObj, List<AgileDataChartValueField> valueFields,
                                                 GrowthRateMeasurePresent measurePresent) {
        GrowthRateParams params = measurePresent.getParams();
        String applyToField = params.getApplyToField();
        String value = pageDataJsonObj.getString(applyToField);
        Double dValue = 0.0;
        if (null != value) {
            dValue = Double.parseDouble(value);
        }

//        String nowField = params.getNowField();
//        String previousField = params.getPreviousField();
//        int startIndex = -1, endIndex = -1;
//        for (int i = 0; i < valueFields.size(); i++) {
//            AgileDataChartValueField valueField = valueFields.get(i);
//            if (Objects.equals(previousField, valueField.getName())) {
//                startIndex = i;
//            }
//            if (Objects.equals(nowField, valueField.getName())) {
//                endIndex = i;
//            }
//        }
//        if (-1 == startIndex || endIndex == -1) {
//            return null;
//        }
//
//        Double nowFieldValue = pageDataJsonObj.getDouble(nowField);
//        Double previousFieldValue = pageDataJsonObj.getDouble(previousField);
//
//        if (null == nowFieldValue || null == previousFieldValue) {
//            return null;
//        }
//
//        Double differ = nowFieldValue - previousFieldValue;
//        GrowthRateInterpreterResult result = new GrowthRateInterpreterResult()
//                .setStartIndex(startIndex)
//                .setEndIndex(endIndex)
//                .setStartValue(previousFieldValue)
//                .setEndValue(nowFieldValue)
//                .setDiffer(differ)
//                .setDifferRate(Math.abs(differ / previousFieldValue));
//
//        return result;
        GrowthRateInterpreterResult result = new GrowthRateInterpreterResult()
                .setStartIndex(0)
                .setEndIndex(1)
                .setDifferRate(dValue);

        return result;

    }
}
