package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.measure;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartValueField;

import java.util.List;

/**
 * <p>功能描述：度量呈现解释器接口</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: MeasurePresentInterpreter
 * @Author: zaregoto
 * @Date: 2024/1/24 21:14
 */
public interface MeasurePresentInterpreter<T extends MeasurePresent, R> {

    /**
     * 度量解释，得到一个返回值
     *
     * @param pageDataJsonObj 单个业务数据对象
     * @param valueFields     度量字段清单
     * @param measurePresent  单个度量呈现配置
     * @return
     */
    R interpret(JSONObject pageDataJsonObj, List<AgileDataChartValueField> valueFields, T measurePresent);
}
