package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.statsindex;

import com.digiwin.mobile.mobileuibot.common.string.RegexUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataIntermediateDataItem;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.AgileDataRenderSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataAnalysisData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.chart.AgileDataChartFieldDisplayFormat;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableDecimalRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableUnit;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>功能描述：敏捷数据——统计指标卡类详细设置</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IndexSetting
 * @Author: zaregoto
 * @Date: 2023/12/13 19:04
 */
@Slf4j
@Data
public class IndexSetting implements AgileDataRenderSetting {

    private static final long serialVersionUID = -7797686096822946834L;

    /**
     * 统计指标卡标题
     */
    private String title;

    /**
     * 统计指标卡内容值
     * 没有内容时默认给0
     */
    private String value = "0";

    /**
     * 统计指标是否需要使用百分号，或千分位显示
     * 当使用百分号时，值为percent；
     * 当使用千分位时，值为thousand
     */
    private String percent;

    /**
     * 统计指标的显示精度
     */
    private Integer decimal;

    /**
     * 目前只有amount为金额含义
     */
    private String businessType;

    /**
     * 数据计算逻辑说明
     */
    private String description;

    /**
     * 舍入方式
     */
    private UiBotTableDecimalRule decimalRule;

    /**
     * 计算单位
     */
    private UiBotTableUnit unit;

    /**
     * 用户筛选维度条件
     */
    private List<AgileDataAnalysisData> dimensionData;

    /**
     * 用户筛选度量条件
     */
    private List<AgileDataAnalysisData> measurementData;

    /**
     * 获取实际标题文字
     *
     * @param statisticDataItem
     * @return
     */
    public String getActualTitle(final AgileDataIntermediateDataItem statisticDataItem) {
        // TODO 保留未来可能需要对标题文字做格式化的空间
        return this.title;
    }

    /**
     * 获取实际指标内容的展示文字
     *
     * @param statisticDataItem
     * @return
     */
    public String getActualValue(final AgileDataIntermediateDataItem statisticDataItem) {
        if (RegexUtil.isMatch(RegexUtil.REGEX_POSITIVE_NEGATIVE_DECIMAL_NUMBER, this.value)) {
            return this.getActualValueFormatted(this.value, statisticDataItem);
        } else {
            return this.value;
        }
    }

    /**
     * 通用方法获取实际指标内容的展示文字
     *
     * @param value 待展示的文字
     * @return
     */
    private String getActualValueFormatted(final String value,
                                           final AgileDataIntermediateDataItem statisticDataItem) {
        AgileDataChartFieldDisplayFormat format = new AgileDataChartFieldDisplayFormat()
                .setPercent(this.percent)
                .setDecimal(this.decimal);
        if (null == this.decimal) {
            return this.value;
        }
        return format.getFormattedString(new BigDecimal(this.value).doubleValue());
    }
}