package com.digiwin.mobile.mobileuibot.proxy.uibot.model.agiledata.table;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>功能描述：敏捷数据——表格栏位定义</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: TableColumnDefinition
 * @Author: zaregoto
 * @Date: 2023/12/29 10:35
 */
@Data
public class TableColumnDefinition implements Serializable {

    private static final long serialVersionUID = -8441125329733827394L;

    private String headerName;
    private String schema;
    private String path;
    private Integer level;
    private JSONArray operations;
    private Integer width;
    private Boolean hide;
    private List<UiBotTableColumn> columns;
    private List headers;
    private Boolean isUserDefined;

    /**
     * 数据计算逻辑说明
     */
    private String description;

    public static List<UiBotTableColumn> decomposeTableColumnDefinitions(List<TableColumnDefinition> columnDefinitionList) {
        List<UiBotTableColumn> result = new ArrayList<>();

        for (TableColumnDefinition tableColumnDefinition : columnDefinitionList) {
            if (!CollectionUtils.isEmpty(tableColumnDefinition.getColumns())) {
                result.addAll(TableColumnDefinition.decomposeTableColumn(tableColumnDefinition.getColumns()));
            } else {
                // 不会发生该情况，在TableColumnDefinition下一定会有UiBotTableColumnd存在。留空方便理解逻辑。
            }
        }
        return result;
    }

    public static List<UiBotTableColumn> decomposeTableColumn(List<UiBotTableColumn> tableColumns) {
        List<UiBotTableColumn> result = new ArrayList<>();
        for (UiBotTableColumn tableColumn : tableColumns) {
            if (!CollectionUtils.isEmpty(tableColumn.getColumns())) {
                result.addAll(TableColumnDefinition.decomposeTableColumn(tableColumn.getColumns()));
            } else {
                result.add(tableColumn);
            }
        }
        return result;
    }

    /**
     * 判断当前列是否更适合用复合列（组合列）模式
     * 子列数量大于1，或数量为1且type是NAME_CODE_COMPONENT时，是适合的
     *
     * @return
     */
    public boolean preferCompoundMode() {
        if (CollectionUtils.isEmpty(this.columns)) {
            return false;
        }
        if (this.columns.size() > 1) {
            return true;
        } else if (this.columns.size() == 1) {
            UiBotTableColumn singleColumn = columns.get(0);
            if (Objects.equals("NAME_CODE_COMPONENT", singleColumn.getType())) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}