package com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotAttachment
 * @Author: Zaregoto
 * @Date: 2021/6/15 18:59
 */
public class UiBotAttachment implements Serializable {
    private static final long serialVersionUID = 3787749379633813822L;

    private String rowDataKey;

    @JsonProperty("row_data")
    @JSONField(name = "row_data")
    private Object rowData;

    private List<UiBotAttachmentData> data;

    public UiBotAttachment() {
        this.data = new ArrayList<>();
    }

    public static UiBotAttachment createEmpty() {
        return new UiBotAttachment();
    }

    public String getRowDataKey() {
        return rowDataKey;
    }

    public void setRowDataKey(String rowDataKey) {
        this.rowDataKey = rowDataKey;
    }

    public Object getRowData() {
        return rowData;
    }

    public void setRowData(Object rowData) {
        this.rowData = rowData;
    }

    public List<UiBotAttachmentData> getData() {
        return data;
    }

    public void setData(List<UiBotAttachmentData> data) {
        this.data = data;
    }

    public void addData(UiBotAttachmentData uiBotAttachmentData) {
        if (null != uiBotAttachmentData) {
            this.data.add(uiBotAttachmentData);
        }
    }

    /**
     * 筛选出不是DELETE状态的文件
     */
    public void filterNotDelete() {
        List<UiBotAttachmentData> dataList = this.data;
        List<UiBotAttachmentData> newDataList = dataList.stream().filter(data -> !AttachmentFile.FILE_STATUS_DELETE.equalsIgnoreCase(data.getUibotStatus()))
                .collect(Collectors.toList());
        this.setData(newDataList);
    }
}
