package com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotAttachmentData
 * @Author: Zaregoto
 * @Date: 2021/6/15 18:59
 */
@Data
public class UiBotAttachmentData implements Serializable {
    private static final long serialVersionUID = -9163137989131758393L;

    private String id;
    // 文件完整名称，包含后缀名
    private String name;
    private String rowDataKey;

    @JsonProperty("row_data")
    @JSONField(name = "row_data")
    private Object rowData;

    @JsonProperty("uibot__status")
    @JSONField(name = "uibot__status")
    private String uibotStatus;

    private String categoryId;
    private String category;
    // 文件大小，单位：字节
    private Double size;
    @JsonProperty("upload_user_name")
    @JSONField(name = "upload_user_name")
    private String uploadUserName;
    // 格式 YYYY-MM-DD HH:MM:SS
    @JsonProperty("create_date")
    @JSONField(name = "create_date")
    private String createDate;
    private String shareUrl;

    private String tenantId;
    private String projectId;
    private String taskId;

    private String base64Data;
    //base64Id,因为地端数据太大只传id
    private String base64DataId;
    //视频封面的base64
    private String coverBase64Data;

    //文件后缀
    private String fileExtension;
    /**
     * 下面字段是签核页面附件使用,不给会报项目异常错误
     */
    @JsonProperty("createDate")
    @JSONField(name = "createDate")
    private String approvalCreateDate;

    public UiBotAttachmentData() {
    }

    public UiBotAttachmentData(String id, String name, Double size, String uploadUserName, String createDate) {
        this.id = id;
        this.name = name;
        this.size = size;
        this.uploadUserName = uploadUserName;
        this.createDate = createDate;
    }
}