package com.digiwin.mobile.mobileuibot.proxy.uibot.model.button;

import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTmDataFilter;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotTipSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import lombok.Data;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotQueryButton
 * @Author: Zaregoto
 * @Date: 2021/5/17 22:31
 */
@Data
public class UiBotQueryButton extends UiBotButton implements Serializable {
    private static final long serialVersionUID = -2045814171903093108L;

    private String dataStateCode;
    private String queryTitle;
    private Long rowSize;
    private String type;
    private Boolean defaultShow;
    private PcUiBotTmDataFilter dataFilter;
    // TODO 使用对象，不用map
    private Map<String, Object> dataSourceSet;
    private List<UiBotAction> submitActions;
    // TODO 使用对象，不用map
    private List<Map<String, Object>> operations;
    private String startApproveActivityName;
    private UiBotExecuteContext executeContext;
    private String version;
    private Boolean showSubmitActions;
    private Boolean finished;
    private Boolean isDefault;
    private Boolean isDesignerDsl;
    private Boolean merge;

    // ------------------------移动设计器新增属性--------------------------------
    /**
     * 是否显示数据状态的标题 -- 移动设计器新增属性
     * 默认true显示
     */
    private Boolean showTitle;
    /**
     * 预设页面，进入页面默认显示的数据状态code -- 移动设计器新增字段
     */
    private String defaultTabMobileCode;
    /**
     * 移动页面控件和布局
     */
    private List<UiBotPageLayout> pageLayout;
    /**
     * 移动任务提示配置
     */
    private UiBotTipSetting tipSetting;

    /**
     * 高级属性
     */
    private List<Map<String, Object>> hooks;

    public UiBotQueryButton() {
    }

    /**
     * 获取主页面所有的pageID和数据源
     *
     * @return
     */
    public Map<String, Map<String, Object>> getPageLayoutInfo() {
        Map<String, Map<String, Object>> pageLayoutInfo = new HashMap(2);
        if (ObjectUtils.isEmpty(pageLayout)) {
            return new HashMap<>();
        }
        for (UiBotPageLayout layout : this.pageLayout) {
            if (ObjectUtils.isEmpty(layout.getPageId())) {
                continue;
            }
            HashMap<String, Object> map = new HashMap<>(2);
            map.put("dataSource", layout.getDataSource());
            map.put("node", layout.getNode());
            map.put("nodePath", layout.getNodePath());
            pageLayoutInfo.put(layout.getPageId(), map);
        }
        return pageLayoutInfo;
    }
}
