package com.digiwin.mobile.mobileuibot.proxy.uibot.model.field;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableAttachmentColumnAttribute;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditor;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnEditorOption;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotField
 * @Author: Zaregoto
 * @Date: 2021/5/17 12:37
 */
@Deprecated
public class UiBotField implements Serializable {
    private static final long serialVersionUID = 2605940011936002692L;

    public static final String VALUE_EMPTY_SYMBOL = "-";

    private JSONObject attribute;
    private String currencyField;
    private String dataType;
    private Boolean editable = false;
    private String headerName;
    private String id;
    private Boolean important = false;
    private JSONArray operations;
    private List<UiBotFieldOption> options;
    private Map<String, UiBotQueryApi> queryCurrencyApi;
    private Map<String, String> queryCurrencyAPIReturnFields;
    private String schema;
    private Boolean thousandthPercentile = false;
    private String title;
    private String type;
    private List<UiBotField> group;

    /*********************************************************************************************
     * ******************************** 移动端特有属性 BEGIN ****************************************
     *********************************************************************************************/
    /**
     * 内容的组件类型
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    private String mContentType;
    private Integer ocrType;

    /*********************************************************************************************
     * ******************************** 移动端特有属性 END *****************************************
     *********************************************************************************************/

    public UiBotField() {
    }

    public UiBotTableColumn parseToTableColumn() {
        UiBotTableColumn uiBotTableColumn = new UiBotTableColumn();
        uiBotTableColumn.setSchema(this.getSchema());
        uiBotTableColumn.setHeaderName(this.getHeaderName());
        uiBotTableColumn.setType(this.getType());
        uiBotTableColumn.setDataType(this.getDataType());
        uiBotTableColumn.setEditable(this.getEditable());
        uiBotTableColumn.setAttribute(JsonUtil.objectToJavaObject(this.getAttribute(), UiBotTableAttachmentColumnAttribute.class));
        uiBotTableColumn.setOcrType(this.getOcrType());
        uiBotTableColumn.setMContentType(this.mContentType);
        UiBotTableColumnEditor columnEditor = new UiBotTableColumnEditor();
        columnEditor.setOptions(JsonUtil.objectToJavaObject(this.getOptions(), new TypeReference<List<UiBotTableColumnEditorOption>>() {
        }));
        columnEditor.setSchema(this.getSchema());
        columnEditor.setType(this.getType());
        uiBotTableColumn.setEditor(columnEditor);

        if (this.group != null) {
            List<UiBotTableColumn> uiBotTableColumns = new ArrayList<>(this.group.size());
            for (UiBotField uiBotField : this.group) {
                uiBotTableColumns.add(uiBotField.parseToTableColumn());
            }
            uiBotTableColumn.setColumns(uiBotTableColumns);
        }
        return uiBotTableColumn;
    }

    public boolean canEdit() {
        return false;
    }

    /**
     * 获取获取提交参数名对应关系（web中backFills字段）
     *
     * @return Map--key为获取到的参数名，value为提交要用的参数名
     */
    public Map<String, String> getBackFills() {
        Map<String, String> backFillMap = new HashMap<>();
        if (operations == null || operations.isEmpty()) {
            return backFillMap;
        }
        JSONObject operation = operations.getJSONObject(0);
        JSONObject openWindowDefine = operation.getJSONObject("openWindowDefine");
        if (openWindowDefine == null || openWindowDefine.get("buttons") == null) {
            return backFillMap;
        }
        JSONArray buttons = openWindowDefine.getJSONArray("buttons");
        if (buttons.isEmpty()) {
            return backFillMap;
        }
        JSONArray actions = new JSONArray();
        for (int i = 0; i < buttons.size(); i++) {
            JSONObject button = buttons.getJSONObject(i);
            if (button != null && "confirm".equalsIgnoreCase(button.getString("id"))) {
                actions = button.getJSONArray("actions");
                break;
            }
        }
        if (actions == null || actions.isEmpty() || actions.get(0) == null) {
            return backFillMap;
        }
        JSONObject action = actions.getJSONObject(0);
        JSONArray backFills = action.getJSONArray("backFills");
        if (backFills == null || backFills.isEmpty()) {
            return backFillMap;
        }
        backFills.stream().forEach(backFill -> {
            JSONObject backFillObj = JsonUtil.objectToJavaObject(backFill, JSONObject.class);
            String key = backFillObj.getString("valueScript");
            String value = backFillObj.getString("key");
            //解析valueScript（selectedObject['id']）
            if (key.contains("'")) {
                String[] keys = key.split("'");
                if (keys.length == 3) {
                    key = keys[1];
                }
            }
            backFillMap.put(key, value);
        });
        return backFillMap;
    }

    /**
     * 根据字段的数据类型及展示类型，返回字段的值的文字展示内容
     *
     * @param bizData
     * @return
     */
    public String getValueForDisplay(Map<String, Object> bizData) {
        return this.parseToTableColumn().getValueForDisplay(bizData);
    }

    /**
     * 根据栏位编辑为SELECT的类型，从options属性中获取对应值的外显标题。
     * FIXME 临时做法，先这样解析，但应该有漏洞
     * 示例JSON数据如下：
     * options: [{title: "未报价", value: "1"}, {title: "需求维护", value: "2"}]
     * 0: {title: "未报价", value: "1"}
     * 1: {title: "需求维护", value: "2"}
     * ]
     *
     * @param uiBotField   字段对象
     * @param bizDataValue 业务数据值
     * @return
     */
    private String getSelectFieldOptionTitle(UiBotField uiBotField, String bizDataValue) {
        if (null == uiBotField.getOptions()) {
            return VALUE_EMPTY_SYMBOL;
        }
        for (UiBotFieldOption option : uiBotField.getOptions()) {
            String optionValue = String.valueOf(option.getValue());
            if (optionValue.equalsIgnoreCase(bizDataValue)) {
                return String.valueOf(option.getTitle());
            }
        }
        return VALUE_EMPTY_SYMBOL;
    }

    public JSONObject getAttribute() {
        return attribute;
    }

    public void setAttribute(JSONObject attribute) {
        this.attribute = attribute;
    }

    public String getCurrencyField() {
        return currencyField;
    }

    public void setCurrencyField(String currencyField) {
        this.currencyField = currencyField;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public String getHeaderName() {
        return headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getImportant() {
        return important;
    }

    public void setImportant(Boolean important) {
        this.important = important;
    }

    public JSONArray getOperations() {
        return operations;
    }

    public void setOperations(JSONArray operations) {
        this.operations = operations;
    }

    public List<UiBotFieldOption> getOptions() {
        return options;
    }

    public void setOptions(List<UiBotFieldOption> options) {
        this.options = options;
    }

    public Map<String, UiBotQueryApi> getQueryCurrencyApi() {
        return queryCurrencyApi;
    }

    public void setQueryCurrencyApi(Map<String, UiBotQueryApi> queryCurrencyApi) {
        this.queryCurrencyApi = queryCurrencyApi;
    }

    public Map<String, String> getQueryCurrencyAPIReturnFields() {
        return queryCurrencyAPIReturnFields;
    }

    public void setQueryCurrencyAPIReturnFields(Map<String, String> queryCurrencyAPIReturnFields) {
        this.queryCurrencyAPIReturnFields = queryCurrencyAPIReturnFields;
    }

    public String getSchema() {
        return schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Boolean getThousandthPercentile() {
        return thousandthPercentile;
    }

    public void setThousandthPercentile(Boolean thousandthPercentile) {
        this.thousandthPercentile = thousandthPercentile;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<UiBotField> getGroup() {
        return group;
    }

    public void setGroup(List<UiBotField> group) {
        this.group = group;
    }

    public String getMContentType() {
        return mContentType;
    }

    public void setmContentType(String mContentType) {
        this.mContentType = mContentType;
    }

    public Integer getOcrType() {
        return ocrType;
    }

    public void setOcrType(Integer ocrType) {
        this.ocrType = ocrType;
    }
}
