package com.digiwin.mobile.mobileuibot.proxy.uibot.model.field.analyzer;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.currency.CurrencyUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: LabelFieldAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/18 17:25
 */
@Component("labelFieldAnalyzer")
public class LabelFieldAnalyzer implements FieldAnalyzer<String> {

    private static final Logger logger = LoggerFactory.getLogger(LabelFieldAnalyzer.class);

    public static final String FIELD_TYPE = "LABEL";

    private static final String FIELD_LABEL_VALUE_TEMPLATE = "%s: %s";
    private static final String FIELD_VALUE_TEMPLATE = "%s";

    private static final String FIELD_TYPE_CHECK_ERROR_MSG =
            String.format("Only %s type field can be anaylyzed", FIELD_TYPE);

    @Override
    public String analyze(UiBotLayout uiBotLayout, JSONObject data,
                          UiBotPageData pageData, Boolean valueOnly) {
        Assert.notNull(uiBotLayout, "uiBotField must not be null");
//        Assert.isTrue(FIELD_TYPE.equalsIgnoreCase(uiBotField.getType()), FIELD_TYPE_CHECK_ERROR_MSG);

        String title = uiBotLayout.getTitle();
        String schema = uiBotLayout.getSchema();
        String type = uiBotLayout.getType();
        Boolean thousandthPercentile = uiBotLayout.getThousandthPercentile();
        if (null == data || data.isEmpty()) {
            if (valueOnly) {
                return String.format(FIELD_VALUE_TEMPLATE, "—");
            } else {
                return String.format(FIELD_LABEL_VALUE_TEMPLATE, "—");
            }
        }

        String value = data.getString(schema);
        if (null != thousandthPercentile && thousandthPercentile && "AMOUNT".equalsIgnoreCase(type)) {
            value = CurrencyUtil.fmtMicrometer(value);

            // FIXME 币别获取这样做不稳定，接口容易没数据
            Map<String, Object> uibotGlobalParameter =
                    (Map<String, Object>) pageData.get("uibot__global_parameter");
            if (uibotGlobalParameter != null) {
                String localCurrency = (String) uibotGlobalParameter.get("local_currency");
                if (null != localCurrency && localCurrency.trim().length() > 0) {
                    value = localCurrency + value;
                }
            }
        }
        if (valueOnly) {
            return String.format(FIELD_VALUE_TEMPLATE, value);
        } else {
            return String.format(FIELD_LABEL_VALUE_TEMPLATE, title, value);
        }
    }
}
